/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.SyncSettingArg;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public class ContentSyncSettingArg {
    protected final String id;
    protected final SyncSettingArg syncSetting;

    public ContentSyncSettingArg(String id, SyncSettingArg syncSetting) {
        if (id == null) {
            throw new IllegalArgumentException("Required value for 'id' is null");
        }
        if (id.length() < 4) {
            throw new IllegalArgumentException("String 'id' is shorter than 4");
        }
        if (!Pattern.matches("id:.+", id)) {
            throw new IllegalArgumentException("String 'id' does not match pattern");
        }
        this.id = id;
        if (syncSetting == null) {
            throw new IllegalArgumentException("Required value for 'syncSetting' is null");
        }
        this.syncSetting = syncSetting;
    }

    public String getId() {
        return this.id;
    }

    public SyncSettingArg getSyncSetting() {
        return this.syncSetting;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.id, this.syncSetting});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            ContentSyncSettingArg other = (ContentSyncSettingArg)obj;
            return !(this.id != other.id && !this.id.equals(other.id) || this.syncSetting != other.syncSetting && !this.syncSetting.equals((Object)other.syncSetting));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends StructSerializer<ContentSyncSettingArg> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(ContentSyncSettingArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("id");
            StoneSerializers.string().serialize(value.id, g);
            g.writeFieldName("sync_setting");
            SyncSettingArg.Serializer.INSTANCE.serialize(value.syncSetting, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public ContentSyncSettingArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            SyncSettingArg f_syncSetting;
            String f_id;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_id = null;
                f_syncSetting = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("id".equals(field)) {
                        f_id = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("sync_setting".equals(field)) {
                        f_syncSetting = SyncSettingArg.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_id == null) {
                    throw new JsonParseException(p, "Required field \"id\" missing.");
                }
                if (f_syncSetting == null) {
                    throw new JsonParseException(p, "Required field \"sync_setting\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            ContentSyncSettingArg value = new ContentSyncSettingArg(f_id, f_syncSetting);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

