/*
 * Decompiled with CFR 0.152.
 */
package pl.muninn.simple.validation.validator.typed;

import java.io.Serializable;
import pl.muninn.simple.validation.failures.common.EmptyField;
import pl.muninn.simple.validation.failures.common.EqualValue;
import pl.muninn.simple.validation.failures.common.ExpectedEmpty;
import pl.muninn.simple.validation.failures.common.ExpectedLength;
import pl.muninn.simple.validation.failures.common.MaximalLength;
import pl.muninn.simple.validation.failures.common.MinimalLength;
import pl.muninn.simple.validation.validator.ValueValidator;
import pl.muninn.simple.validation.validator.ValueValidator$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.runtime.BoxesRunTime;

public final class CommonValidators$ {
    public static final CommonValidators$ MODULE$ = new CommonValidators$();

    public <T> ValueValidator<T> equal(T expected, Function2<T, T, Object> equal) {
        return ValueValidator$.MODULE$.instance((Function0 & Serializable)() -> (Function2 & Serializable)(key, value) -> {
            if (BoxesRunTime.unboxToBoolean((Object)equal.apply(value, expected))) {
                return ValueValidator$.MODULE$.valid();
            }
            return ValueValidator$.MODULE$.invalid(new EqualValue<Object>((String)key, expected, value));
        });
    }

    public <T> ValueValidator<T> empty(Function1<T, Object> empty) {
        return ValueValidator$.MODULE$.instance((Function0 & Serializable)() -> (Function2 & Serializable)(key, value) -> {
            if (BoxesRunTime.unboxToBoolean((Object)empty.apply(value))) {
                return ValueValidator$.MODULE$.valid();
            }
            return ValueValidator$.MODULE$.invalid(new ExpectedEmpty((String)key));
        });
    }

    public <T> ValueValidator<T> notEmpty(Function1<T, Object> emptyMagnetic) {
        return ValueValidator$.MODULE$.instance((Function0 & Serializable)() -> (Function2 & Serializable)(key, value) -> {
            if (BoxesRunTime.unboxToBoolean((Object)emptyMagnetic.apply(value))) {
                return ValueValidator$.MODULE$.invalid(new EmptyField((String)key));
            }
            return ValueValidator$.MODULE$.valid();
        });
    }

    public <T> ValueValidator<T> minimalLength(int expected, Function1<T, Object> length) {
        return ValueValidator$.MODULE$.instance((Function0 & Serializable)() -> (Function2 & Serializable)(key, value) -> {
            int valueLength = BoxesRunTime.unboxToInt((Object)length.apply(value));
            if (valueLength >= expected) {
                return ValueValidator$.MODULE$.valid();
            }
            return ValueValidator$.MODULE$.invalid(new MinimalLength<Integer, Integer>((String)key, BoxesRunTime.boxToInteger((int)expected), BoxesRunTime.boxToInteger((int)valueLength)));
        });
    }

    public <T> ValueValidator<T> maximalLength(int expected, Function1<T, Object> length) {
        return ValueValidator$.MODULE$.instance((Function0 & Serializable)() -> (Function2 & Serializable)(key, value) -> {
            int valueLength = BoxesRunTime.unboxToInt((Object)length.apply(value));
            if (valueLength <= expected) {
                return ValueValidator$.MODULE$.valid();
            }
            return ValueValidator$.MODULE$.invalid(new MaximalLength<Integer, Integer>((String)key, BoxesRunTime.boxToInteger((int)expected), BoxesRunTime.boxToInteger((int)valueLength)));
        });
    }

    public <T> ValueValidator<T> exactLength(int expected, Function1<T, Object> length) {
        return ValueValidator$.MODULE$.instance((Function0 & Serializable)() -> (Function2 & Serializable)(key, value) -> {
            int valueLength = BoxesRunTime.unboxToInt((Object)length.apply(value));
            if (valueLength == expected) {
                return ValueValidator$.MODULE$.valid();
            }
            return ValueValidator$.MODULE$.invalid(new ExpectedLength<Integer, Integer>((String)key, BoxesRunTime.boxToInteger((int)expected), BoxesRunTime.boxToInteger((int)valueLength)));
        });
    }

    private CommonValidators$() {
    }
}

