/*
 * Decompiled with CFR 0.152.
 */
package pl.morgwai.base.servlet.guice.scopes.connectionproxy.tyrus;

import jakarta.websocket.Session;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.glassfish.tyrus.core.TyrusSession;
import org.glassfish.tyrus.core.cluster.DistributedSession;
import pl.morgwai.base.guice.scopes.ContextTracker;
import pl.morgwai.base.servlet.guice.scopes.ContainerCallContext;
import pl.morgwai.base.servlet.guice.scopes.WebsocketConnectionContext;
import pl.morgwai.base.servlet.guice.scopes.WebsocketConnectionProxy;

public class TyrusConnectionProxy
extends WebsocketConnectionProxy {
    public TyrusConnectionProxy(Session connection, ContextTracker<ContainerCallContext> ctxTracker, boolean remote) {
        super(connection, ctxTracker, remote);
    }

    public Set<Session> getOpenSessions() {
        Set localPeerConnections = this.wrappedConnection.getOpenSessions();
        Set remotePeerConnections = ((TyrusSession)this.wrappedConnection).getRemoteSessions();
        HashSet<Session> proxies = new HashSet<Session>(localPeerConnections.size() + remotePeerConnections.size(), 1.0f);
        for (DistributedSession peerConnection : localPeerConnections) {
            WebsocketConnectionContext peerConnectionCtx = (WebsocketConnectionContext)peerConnection.getDistributedProperties().get(WebsocketConnectionContext.class.getName());
            proxies.add(peerConnectionCtx.getConnection());
        }
        for (DistributedSession peerConnection : remotePeerConnections) {
            proxies.add((Session)new TyrusConnectionProxy((Session)peerConnection, (ContextTracker<ContainerCallContext>)this.ctxTracker, true));
        }
        return proxies;
    }

    public Map<String, Object> getUserProperties() {
        return ((DistributedSession)this.wrappedConnection).getDistributedProperties();
    }

    public static class Factory
    implements WebsocketConnectionProxy.Factory {
        public WebsocketConnectionProxy newProxy(Session connection, ContextTracker<ContainerCallContext> ctxTracker) {
            return new TyrusConnectionProxy(connection, ctxTracker, false);
        }

        public Class<? extends Session> getSupportedConnectionType() {
            return TyrusSession.class;
        }
    }
}

