/*
 * Decompiled with CFR 0.152.
 */
package pl.morgwai.base.utils.io;

import java.io.ByteArrayOutputStream;

public class NoCopyByteArrayOutputStream
extends ByteArrayOutputStream {
    byte[] closedBuffer = null;
    static final String STREAM_CLOSED_MESSAGE = "stream already closed";

    public NoCopyByteArrayOutputStream(int initialBufferSize) {
        super(initialBufferSize);
    }

    @Override
    public void close() {
        this.closedBuffer = this.buf;
        this.buf = null;
    }

    public byte[] getBuffer() {
        if (this.closedBuffer == null) {
            throw new IllegalStateException("stream not closed yet");
        }
        return this.closedBuffer;
    }

    @Override
    public void write(int b) {
        try {
            super.write(b);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException(STREAM_CLOSED_MESSAGE);
        }
    }

    @Override
    public void write(byte[] bytes, int offset, int len) {
        try {
            super.write(bytes, offset, len);
        }
        catch (NullPointerException e) {
            if (bytes == null) {
                throw e;
            }
            throw new IllegalStateException(STREAM_CLOSED_MESSAGE);
        }
    }

    @Override
    public void reset() {
        if (this.buf == null) {
            throw new IllegalStateException(STREAM_CLOSED_MESSAGE);
        }
        super.reset();
    }
}

