/*
 * Decompiled with CFR 0.152.
 */
package pl.morgwai.base.utils.concurrent;

import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import pl.morgwai.base.utils.concurrent.TaskTrackingExecutor;

public class TaskTrackingThreadPoolExecutor
extends ThreadPoolExecutor
implements TaskTrackingExecutor,
TaskTrackingExecutor.TaskTrackingExecutorDecorator.HookableExecutor {
    final TaskTrackingExecutor.TaskTrackingExecutorDecorator taskTrackingDecorator;
    final Deque<BiConsumer<Thread, Runnable>> beforeExecuteHooks = new LinkedList<BiConsumer<Thread, Runnable>>();
    final List<BiConsumer<Runnable, Throwable>> afterExecuteHooks = new LinkedList<BiConsumer<Runnable, Throwable>>();

    public TaskTrackingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.taskTrackingDecorator = this.createAndSetupTaskTrackingDecorator();
    }

    TaskTrackingExecutor.TaskTrackingExecutorDecorator createAndSetupTaskTrackingDecorator() {
        TaskTrackingExecutor.TaskTrackingExecutorDecorator decorator = new TaskTrackingExecutor.TaskTrackingExecutorDecorator(this, this.getCorePoolSize());
        this.setThreadFactory(decorator.decorateThreadFactory(this.getThreadFactory()));
        return decorator;
    }

    @Override
    public List<Runnable> getRunningTasks() {
        return this.taskTrackingDecorator.getRunningTasks();
    }

    @Override
    public void addBeforeExecuteHook(BiConsumer<Thread, Runnable> hook) {
        this.beforeExecuteHooks.addFirst(hook);
    }

    @Override
    protected final void beforeExecute(Thread worker, Runnable task) {
        this.beforeExecuteHooks.forEach(hook -> hook.accept(worker, task));
    }

    @Override
    public void addAfterExecuteHook(BiConsumer<Runnable, Throwable> hook) {
        this.afterExecuteHooks.add(hook);
    }

    @Override
    protected final void afterExecute(Runnable task, Throwable error) {
        this.afterExecuteHooks.forEach(hook -> hook.accept(task, error));
    }

    public TaskTrackingThreadPoolExecutor(int poolSize) {
        this(poolSize, poolSize, 0L, TimeUnit.DAYS, new LinkedBlockingQueue<Runnable>());
    }

    public TaskTrackingThreadPoolExecutor(int poolSize, int queueSize) {
        this(poolSize, poolSize, 0L, TimeUnit.DAYS, new LinkedBlockingQueue<Runnable>(queueSize));
    }

    public TaskTrackingThreadPoolExecutor(int poolSize, int queueSize, ThreadFactory threadFactory) {
        this(poolSize, poolSize, 0L, TimeUnit.DAYS, new LinkedBlockingQueue<Runnable>(queueSize), threadFactory);
    }

    public TaskTrackingThreadPoolExecutor(int poolSize, int queueSize, RejectedExecutionHandler handler) {
        this(poolSize, poolSize, 0L, TimeUnit.DAYS, new LinkedBlockingQueue<Runnable>(queueSize), handler);
    }

    public TaskTrackingThreadPoolExecutor(int poolSize, int queueSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        this(poolSize, poolSize, 0L, TimeUnit.DAYS, new LinkedBlockingQueue<Runnable>(queueSize), threadFactory, handler);
    }

    public TaskTrackingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        this.taskTrackingDecorator = this.createAndSetupTaskTrackingDecorator();
    }

    public TaskTrackingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.taskTrackingDecorator = this.createAndSetupTaskTrackingDecorator();
    }

    public TaskTrackingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
        this.taskTrackingDecorator = this.createAndSetupTaskTrackingDecorator();
    }
}

