/*
 * Decompiled with CFR 0.152.
 */
package pl.morgwai.base.utils.concurrent;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import pl.morgwai.base.utils.concurrent.Awaitable;

public interface TaskTrackingExecutor
extends ExecutorService {
    public List<Runnable> getRunningTasks();

    default public Awaitable.WithUnit toAwaitableOfTermination() {
        return Awaitable.ofTermination(this);
    }

    default public Awaitable.WithUnit toAwaitableOfEnforcedTermination() {
        return Awaitable.ofEnforcedTermination(this);
    }

    default public void awaitTermination() throws InterruptedException {
        while (!this.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS)) {
        }
    }

    public static class TaskTrackingExecutorDecorator
    extends AbstractExecutorService
    implements TaskTrackingExecutor {
        final ExecutorService backingExecutor;
        final Set<TaskHolder> runningTasks;
        final boolean backingExecutorHookable;
        ThreadLocal<TaskHolder> threadLocalTaskHolder = new ThreadLocal();

        public TaskTrackingExecutorDecorator(ExecutorService executorToDecorate, int threadPoolSize) {
            this(executorToDecorate, false, threadPoolSize);
        }

        public TaskTrackingExecutorDecorator(ExecutorService executorToDecorate) {
            this(executorToDecorate, -1);
        }

        public TaskTrackingExecutorDecorator(HookableExecutor executorToDecorate, int threadPoolSize) {
            this(executorToDecorate, true, threadPoolSize);
            executorToDecorate.addBeforeExecuteHook((worker, task) -> this.storeTaskIntoHolderBeforeExecute((Runnable)task));
            executorToDecorate.addAfterExecuteHook((task, error) -> this.clearTaskHolderAfterExecute());
        }

        public TaskTrackingExecutorDecorator(HookableExecutor executorToDecorate) {
            this(executorToDecorate, -1);
        }

        public TaskTrackingExecutorDecorator(ThreadPoolExecutor executorToDecorate) {
            this(executorToDecorate, false, executorToDecorate.getCorePoolSize());
            if (executorToDecorate.getActiveCount() > 0) {
                throw new IllegalStateException("executor must be idle to decorate it with TaskTrackingExecutorDecorator");
            }
            RejectedExecutionHandler originalHandler = executorToDecorate.getRejectedExecutionHandler();
            executorToDecorate.setRejectedExecutionHandler((wrappedTask, rejectingExecutor) -> originalHandler.rejectedExecution(((TrackableTask)wrappedTask).wrappedTask, rejectingExecutor));
            executorToDecorate.setThreadFactory(this.decorateThreadFactory(executorToDecorate.getThreadFactory()));
            int corePoolSize = executorToDecorate.getCorePoolSize();
            executorToDecorate.setCorePoolSize(0);
            executorToDecorate.setCorePoolSize(corePoolSize);
        }

        public ThreadFactory decorateThreadFactory(ThreadFactory factoryToDecorate) {
            return task -> factoryToDecorate.newThread(() -> {
                try {
                    task.run();
                }
                finally {
                    TaskHolder taskHolder = this.threadLocalTaskHolder.get();
                    if (taskHolder != null) {
                        this.runningTasks.remove(taskHolder);
                    }
                }
            });
        }

        TaskTrackingExecutorDecorator(ExecutorService executorToDecorate, boolean backingExecutorHookable, int threadPoolSize) {
            this.runningTasks = threadPoolSize > 0 ? ConcurrentHashMap.newKeySet(threadPoolSize) : ConcurrentHashMap.newKeySet();
            this.backingExecutor = executorToDecorate;
            this.backingExecutorHookable = backingExecutorHookable;
        }

        @Override
        public List<Runnable> getRunningTasks() {
            return this.runningTasks.stream().map(holder -> holder.task).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.backingExecutorHookable ? this.backingExecutor.shutdownNow() : this.backingExecutor.shutdownNow().stream().map(TrackableTask.class::cast).map(TrackableTask::getWrappedTask).collect(Collectors.toUnmodifiableList());
        }

        void storeTaskIntoHolderBeforeExecute(Runnable task) {
            TaskHolder taskHolder = this.threadLocalTaskHolder.get();
            if (taskHolder == null) {
                taskHolder = new TaskHolder();
                this.threadLocalTaskHolder.set(taskHolder);
                this.runningTasks.add(taskHolder);
            }
            taskHolder.task = task;
        }

        void clearTaskHolderAfterExecute() {
            this.threadLocalTaskHolder.get().task = null;
        }

        @Override
        public void execute(Runnable task) {
            this.backingExecutor.execute(this.backingExecutorHookable ? task : new TrackableTask(task));
        }

        public static Runnable unwrapTask(Runnable task) {
            return task instanceof TrackableTask ? ((TrackableTask)task).wrappedTask : task;
        }

        @Override
        public void shutdown() {
            this.backingExecutor.shutdown();
        }

        @Override
        public boolean isShutdown() {
            return this.backingExecutor.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.backingExecutor.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.backingExecutor.awaitTermination(timeout, unit);
        }

        @Deprecated(forRemoval=true)
        public static void decorateRejectedExecutionHandler(ThreadPoolExecutor executor) {
            RejectedExecutionHandler originalHandler = executor.getRejectedExecutionHandler();
            executor.setRejectedExecutionHandler((wrappedTask, rejectingExecutor) -> originalHandler.rejectedExecution(((TrackableTask)wrappedTask).wrappedTask, rejectingExecutor));
        }

        public class TrackableTask
        implements Runnable {
            final Runnable wrappedTask;

            public Runnable getWrappedTask() {
                return this.wrappedTask;
            }

            protected TrackableTask(Runnable taskToWrap) {
                this.wrappedTask = taskToWrap;
            }

            @Override
            public void run() {
                TaskTrackingExecutorDecorator.this.storeTaskIntoHolderBeforeExecute(this.wrappedTask);
                try {
                    this.wrappedTask.run();
                }
                finally {
                    TaskTrackingExecutorDecorator.this.clearTaskHolderAfterExecute();
                }
            }

            public String toString() {
                return this.wrappedTask.toString();
            }
        }

        public static interface HookableExecutor
        extends ExecutorService {
            public void addBeforeExecuteHook(BiConsumer<Thread, Runnable> var1);

            public void addAfterExecuteHook(BiConsumer<Runnable, Throwable> var1);
        }

        static class TaskHolder {
            volatile Runnable task;

            TaskHolder() {
            }
        }
    }
}

