/*
 * Decompiled with CFR 0.152.
 */
package pl.morgwai.base.utils.concurrent;

import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import pl.morgwai.base.utils.concurrent.TaskTrackingExecutor;

public class ScheduledTaskTrackingThreadPoolExecutor
extends ScheduledThreadPoolExecutor
implements TaskTrackingExecutor,
TaskTrackingExecutor.TaskTrackingExecutorDecorator.HookableExecutor {
    final TaskTrackingExecutor.TaskTrackingExecutorDecorator taskTrackingDecorator;
    final Deque<BiConsumer<Thread, Runnable>> beforeExecuteHooks = new LinkedList<BiConsumer<Thread, Runnable>>();
    final List<BiConsumer<Runnable, Throwable>> afterExecuteHooks = new LinkedList<BiConsumer<Runnable, Throwable>>();

    public ScheduledTaskTrackingThreadPoolExecutor(int corePoolSize) {
        super(corePoolSize);
        this.taskTrackingDecorator = new TaskTrackingExecutor.TaskTrackingExecutorDecorator(this, corePoolSize);
    }

    @Override
    public List<Runnable> getRunningTasks() {
        return this.taskTrackingDecorator.getRunningTasks();
    }

    @Override
    public void addBeforeExecuteHook(BiConsumer<Thread, Runnable> hook) {
        this.beforeExecuteHooks.addFirst(hook);
    }

    @Override
    protected final void beforeExecute(Thread worker, Runnable task) {
        this.beforeExecuteHooks.forEach(hook -> hook.accept(worker, task));
    }

    @Override
    public void addAfterExecuteHook(BiConsumer<Runnable, Throwable> hook) {
        this.afterExecuteHooks.add(hook);
    }

    @Override
    protected final void afterExecute(Runnable task, Throwable error) {
        this.afterExecuteHooks.forEach(hook -> hook.accept(task, error));
    }

    protected <V> ScheduledExecution<V> decorateTask(Runnable task, RunnableScheduledFuture<V> scheduledExecution) {
        return new ScheduledExecution<V>(task, scheduledExecution);
    }

    protected <V> ScheduledExecution<V> decorateTask(Callable<V> task, RunnableScheduledFuture<V> scheduledExecution) {
        return new ScheduledExecution<V>(task, scheduledExecution);
    }

    public ScheduledTaskTrackingThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
        this.taskTrackingDecorator = new TaskTrackingExecutor.TaskTrackingExecutorDecorator(this, corePoolSize);
    }

    public ScheduledTaskTrackingThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, handler);
        this.taskTrackingDecorator = new TaskTrackingExecutor.TaskTrackingExecutorDecorator(this, corePoolSize);
    }

    public ScheduledTaskTrackingThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
        this.taskTrackingDecorator = new TaskTrackingExecutor.TaskTrackingExecutorDecorator(this, corePoolSize);
    }

    public static class ScheduledExecution<V>
    implements RunnableScheduledFuture<V> {
        final Object task;
        final RunnableScheduledFuture<V> wrappedScheduledItem;

        public Object getTask() {
            return this.task;
        }

        public ScheduledExecution(Object task, RunnableScheduledFuture<V> scheduledItemToWrap) {
            this.task = task;
            this.wrappedScheduledItem = scheduledItemToWrap;
        }

        @Override
        public boolean isPeriodic() {
            return this.wrappedScheduledItem.isPeriodic();
        }

        @Override
        public void run() {
            this.wrappedScheduledItem.run();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.wrappedScheduledItem.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.wrappedScheduledItem.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.wrappedScheduledItem.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.wrappedScheduledItem.get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.wrappedScheduledItem.get(timeout, unit);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.wrappedScheduledItem.getDelay(unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return this.wrappedScheduledItem.compareTo(o);
        }
    }
}

