/*
 * Decompiled with CFR 0.152.
 */
package pl.morgwai.base.utils.concurrent;

import java.util.LinkedList;
import java.util.List;

public class OrderedConcurrentOutputBuffer<MessageT> {
    final OutputStream<MessageT> output;
    Bucket tailGuard;
    boolean noMoreBuckets = false;
    static final String BUCKET_CLOSED_MESSAGE = "bucket already closed";

    public OrderedConcurrentOutputBuffer(OutputStream<MessageT> outputStream) {
        this.output = outputStream;
        this.tailGuard = new Bucket();
        this.tailGuard.buffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream<MessageT> addBucket() {
        Object object = this.tailGuard.lock;
        synchronized (object) {
            if (this.noMoreBuckets) {
                throw new IllegalStateException("noMoreBuckets already signaled");
            }
            this.tailGuard.next = new Bucket();
            Bucket result = this.tailGuard;
            this.tailGuard = this.tailGuard.next;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalNoMoreBuckets() {
        Object object = this.tailGuard.lock;
        synchronized (object) {
            this.noMoreBuckets = true;
            if (this.tailGuard.buffer == null) {
                this.output.close();
            }
        }
    }

    class Bucket
    implements OutputStream<MessageT> {
        List<MessageT> buffer = new LinkedList();
        boolean closed = false;
        Bucket next;
        final Object lock = new Object();

        Bucket() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(MessageT message) {
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    throw new IllegalStateException(OrderedConcurrentOutputBuffer.BUCKET_CLOSED_MESSAGE);
                }
                if (this.buffer == null) {
                    OrderedConcurrentOutputBuffer.this.output.write(message);
                } else {
                    this.buffer.add(message);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    throw new IllegalStateException(OrderedConcurrentOutputBuffer.BUCKET_CLOSED_MESSAGE);
                }
                this.closed = true;
                if (this.buffer == null) {
                    this.next.flush();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flush() {
            Object object = this.lock;
            synchronized (object) {
                for (Object bufferedMessage : this.buffer) {
                    OrderedConcurrentOutputBuffer.this.output.write(bufferedMessage);
                }
                this.buffer = null;
                if (this.next != null) {
                    if (this.closed) {
                        this.next.flush();
                    }
                } else if (OrderedConcurrentOutputBuffer.this.noMoreBuckets) {
                    OrderedConcurrentOutputBuffer.this.output.close();
                }
            }
        }
    }

    public static interface OutputStream<MessageT> {
        public void write(MessageT var1);

        public void close();
    }
}

