/*
 * Decompiled with CFR 0.152.
 */
package pl.morgwai.base.utils.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntFunction;

public class NamingThreadFactory
implements ThreadFactory {
    final ThreadGroup threadGroup;
    final AtomicInteger threadNumber = new AtomicInteger(0);
    final IntFunction<String> threadNameGenerator;

    public NamingThreadFactory(String name) {
        this(NamingThreadFactory.createThreadGroup(name), i -> name + "-thread-" + i);
    }

    static ThreadGroup createThreadGroup(String name) {
        SecurityManager securityManager = System.getSecurityManager();
        ThreadGroup parentGroup = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        ThreadGroup newGroup = new ThreadGroup(parentGroup, name);
        newGroup.setMaxPriority(5);
        newGroup.setDaemon(false);
        return newGroup;
    }

    public NamingThreadFactory(ThreadGroup threadGroup, IntFunction<String> threadNameGenerator) {
        this.threadGroup = threadGroup;
        this.threadNameGenerator = threadNameGenerator;
    }

    @Override
    public Thread newThread(Runnable task) {
        Thread newThread = new Thread(this.threadGroup, task, this.threadNameGenerator.apply(this.threadNumber.incrementAndGet()));
        newThread.setPriority(this.threadGroup.getMaxPriority());
        newThread.setDaemon(this.threadGroup.isDaemon());
        return newThread;
    }
}

