/*
 * Decompiled with CFR 0.152.
 */
package pl.morgwai.base.utils.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;

public interface ConcurrentUtils {
    public static boolean waitForMonitorCondition(Object monitor, BooleanSupplier condition, long timeout, TimeUnit unit) throws InterruptedException {
        long remainingNanos = unit.toNanos(timeout);
        long deadlineNanos = System.nanoTime() + remainingNanos;
        while (!condition.getAsBoolean()) {
            if (timeout == 0L) {
                monitor.wait();
                continue;
            }
            if (remainingNanos <= 0L) {
                return false;
            }
            monitor.wait(remainingNanos / 1000000L, (int)(remainingNanos % 1000000L));
            remainingNanos = deadlineNanos - System.nanoTime();
        }
        return true;
    }

    public static boolean waitForMonitorCondition(Object monitor, BooleanSupplier condition, long timeoutMillis) throws InterruptedException {
        return ConcurrentUtils.waitForMonitorCondition(monitor, condition, timeoutMillis, TimeUnit.MILLISECONDS);
    }
}

