/*
 * Decompiled with CFR 0.152.
 */
package pl.morgwai.base.utils.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RunnableFuture;

public class CallableTaskExecution<T>
extends CompletableFuture<T>
implements RunnableFuture<T> {
    public final Callable<T> task;

    public Callable<T> getTask() {
        return this.task;
    }

    public CallableTaskExecution(Callable<T> task) {
        this.task = task;
    }

    @Override
    public void run() {
        try {
            this.complete(this.task.call());
        }
        catch (Exception e) {
            this.completeExceptionally(e);
        }
    }

    @Override
    public String toString() {
        return "CallableTaskExecution { task = " + this.task + " }";
    }

    public static <R> CallableTaskExecution<R> callAsync(Callable<R> task, Executor executor) {
        CallableTaskExecution<R> taskExecution = new CallableTaskExecution<R>(task);
        executor.execute(taskExecution);
        return taskExecution;
    }

    public static <R> CallableTaskExecution<R> callAsync(Callable<R> task) {
        CallableTaskExecution<R> taskExecution = new CallableTaskExecution<R>(task);
        taskExecution.defaultExecutor().execute(taskExecution);
        return taskExecution;
    }
}

