/*
 * Decompiled with CFR 0.152.
 */
package pl.morgwai.base.utils.concurrent;

import java.time.Duration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;

@FunctionalInterface
public interface Awaitable {
    public boolean await(long var1) throws InterruptedException;

    default public WithUnit toAwaitableWithUnit() {
        return (timeout, unit) -> this.await(timeout == 0L ? 0L : Math.max(1L, unit.toMillis(timeout)));
    }

    public static WithUnit ofJoin(Thread thread) {
        return (timeout, unit) -> {
            long timeoutMillis = unit.toMillis(timeout);
            if (timeout == 0L || unit.ordinal() >= TimeUnit.MILLISECONDS.ordinal()) {
                thread.join(timeoutMillis);
            } else {
                thread.join(timeoutMillis, (int)(unit.toNanos(timeout) % 1000000L));
            }
            return !thread.isAlive();
        };
    }

    public static WithUnit ofTermination(ExecutorService executor) {
        return (timeout, unit) -> {
            executor.shutdown();
            return executor.awaitTermination(timeout, unit);
        };
    }

    public static WithUnit ofEnforcedTermination(ExecutorService executor) {
        return (timeout, unit) -> {
            try {
                executor.shutdown();
                boolean bl = executor.awaitTermination(timeout, unit);
                return bl;
            }
            finally {
                if (!executor.isTerminated()) {
                    executor.shutdownNow();
                }
            }
        };
    }

    public static <T> List<T> awaitMultiple(long timeout, TimeUnit unit, boolean continueOnInterrupt, Iterator<Entry<T>> awaitableEntries) throws AwaitInterruptedException {
        long remainingNanos = unit.toNanos(timeout);
        long deadlineNanos = System.nanoTime() + remainingNanos;
        LinkedList failedTasks = new LinkedList();
        LinkedList interruptedTasks = new LinkedList();
        boolean interrupted = false;
        while (awaitableEntries.hasNext()) {
            Entry<T> awaitableEntry = awaitableEntries.next();
            try {
                if (!awaitableEntry.operation.toAwaitableWithUnit().await(remainingNanos, TimeUnit.NANOSECONDS)) {
                    failedTasks.add(awaitableEntry.object);
                }
                if (remainingNanos <= 1L || (remainingNanos = deadlineNanos - System.nanoTime()) >= 1L) continue;
                remainingNanos = 1L;
            }
            catch (InterruptedException e) {
                interruptedTasks.add(awaitableEntry.object);
                if (!continueOnInterrupt) {
                    throw new AwaitInterruptedException(failedTasks, interruptedTasks, awaitableEntries);
                }
                remainingNanos = 1L;
                interrupted = true;
            }
        }
        if (interrupted) {
            throw new AwaitInterruptedException(failedTasks, interruptedTasks, awaitableEntries);
        }
        return failedTasks;
    }

    public static <T> Entry<T> newEntry(T object, Awaitable operation) {
        return new Entry<T>(object, operation);
    }

    public static <T> Function<T, Entry<T>> entryMapper(Function<? super T, ? extends Awaitable> adapter) {
        return t -> Awaitable.newEntry(t, (Awaitable)adapter.apply(t));
    }

    @SafeVarargs
    public static <T> List<T> awaitMultiple(long timeout, TimeUnit unit, boolean continueOnInterrupt, Entry<T> ... awaitableEntries) throws AwaitInterruptedException {
        return Awaitable.awaitMultiple(timeout, unit, continueOnInterrupt, Arrays.asList(awaitableEntries).iterator());
    }

    @SafeVarargs
    public static <T> List<T> awaitMultiple(long timeoutMillis, boolean continueOnInterrupt, Entry<T> ... awaitableEntries) throws AwaitInterruptedException {
        return Awaitable.awaitMultiple(timeoutMillis, TimeUnit.MILLISECONDS, continueOnInterrupt, Arrays.asList(awaitableEntries).iterator());
    }

    @SafeVarargs
    public static <T> List<T> awaitMultiple(long timeout, TimeUnit unit, Entry<T> ... awaitableEntries) throws AwaitInterruptedException {
        return Awaitable.awaitMultiple(timeout, unit, true, Arrays.asList(awaitableEntries).iterator());
    }

    @SafeVarargs
    public static <T> List<T> awaitMultiple(long timeoutMillis, Entry<T> ... awaitableEntries) throws AwaitInterruptedException {
        return Awaitable.awaitMultiple(timeoutMillis, TimeUnit.MILLISECONDS, true, Arrays.asList(awaitableEntries).iterator());
    }

    public static <T> List<T> awaitMultiple(long timeout, TimeUnit unit, boolean continueOnInterrupt, Stream<Entry<T>> awaitableEntries) throws AwaitInterruptedException {
        return Awaitable.awaitMultiple(timeout, unit, continueOnInterrupt, awaitableEntries.iterator());
    }

    public static <T> List<T> awaitMultiple(long timeoutMillis, boolean continueOnInterrupt, Stream<Entry<T>> awaitableEntries) throws AwaitInterruptedException {
        return Awaitable.awaitMultiple(timeoutMillis, TimeUnit.MILLISECONDS, continueOnInterrupt, awaitableEntries.iterator());
    }

    public static <T> List<T> awaitMultiple(long timeout, TimeUnit unit, Stream<Entry<T>> awaitableEntries) throws AwaitInterruptedException {
        return Awaitable.awaitMultiple(timeout, unit, true, awaitableEntries.iterator());
    }

    public static <T> List<T> awaitMultiple(long timeoutMillis, Stream<Entry<T>> awaitableEntries) throws AwaitInterruptedException {
        return Awaitable.awaitMultiple(timeoutMillis, TimeUnit.MILLISECONDS, true, awaitableEntries.iterator());
    }

    public static boolean awaitMultiple(long timeout, TimeUnit unit, boolean continueOnInterrupt, Awaitable ... operations) throws AwaitInterruptedException {
        return Awaitable.awaitMultiple(timeout, unit, continueOnInterrupt, Arrays.stream(operations).map(operation -> Awaitable.newEntry(operation, operation)).iterator()).isEmpty();
    }

    public static boolean awaitMultiple(long timeoutMillis, boolean continueOnInterrupt, Awaitable ... operations) throws AwaitInterruptedException {
        return Awaitable.awaitMultiple(timeoutMillis, TimeUnit.MILLISECONDS, continueOnInterrupt, operations);
    }

    public static boolean awaitMultiple(long timeout, TimeUnit unit, boolean continueOnInterrupt, WithUnit ... operations) throws AwaitInterruptedException {
        return Awaitable.awaitMultiple(timeout, unit, continueOnInterrupt, (Awaitable[])operations);
    }

    public static boolean awaitMultiple(long timeoutMillis, boolean continueOnInterrupt, WithUnit ... operations) throws AwaitInterruptedException {
        return Awaitable.awaitMultiple(timeoutMillis, TimeUnit.MILLISECONDS, continueOnInterrupt, (Awaitable[])operations);
    }

    public static boolean awaitMultiple(long timeout, TimeUnit unit, Awaitable ... operations) throws AwaitInterruptedException {
        return Awaitable.awaitMultiple(timeout, unit, true, operations);
    }

    public static boolean awaitMultiple(long timeoutMillis, Awaitable ... operations) throws AwaitInterruptedException {
        return Awaitable.awaitMultiple(timeoutMillis, TimeUnit.MILLISECONDS, true, operations);
    }

    public static boolean awaitMultiple(long timeout, TimeUnit unit, WithUnit ... operations) throws AwaitInterruptedException {
        return Awaitable.awaitMultiple(timeout, unit, true, (Awaitable[])operations);
    }

    public static boolean awaitMultiple(long timeoutMillis, WithUnit ... operations) throws AwaitInterruptedException {
        return Awaitable.awaitMultiple(timeoutMillis, TimeUnit.MILLISECONDS, true, (Awaitable[])operations);
    }

    public static class AwaitInterruptedException
    extends InterruptedException {
        public final List<?> failed;
        public final List<?> interrupted;
        public final Iterator<Entry<?>> unexecuted;
        private static final long serialVersionUID = -5981514983898337530L;

        public List<?> getFailed() {
            return this.failed;
        }

        public List<?> getInterrupted() {
            return this.interrupted;
        }

        public Iterator<Entry<?>> getUnexecuted() {
            return this.unexecuted;
        }

        public <T> AwaitInterruptedException(List<T> failed, List<T> interrupted, Iterator<Entry<T>> unexecuted) {
            this.failed = failed;
            this.interrupted = interrupted;
            Iterator<Entry<T>> tmp = unexecuted;
            this.unexecuted = tmp;
        }
    }

    public static class Entry<T> {
        final T object;
        final Awaitable operation;

        public T getObject() {
            return this.object;
        }

        public Awaitable getOperation() {
            return this.operation;
        }

        public Entry(T object, Awaitable operation) {
            this.object = object;
            this.operation = operation;
        }
    }

    @FunctionalInterface
    public static interface WithUnit
    extends Awaitable {
        public boolean await(long var1, TimeUnit var3) throws InterruptedException;

        default public boolean await(Duration timeout) throws InterruptedException {
            return this.await(timeout.toNanos(), TimeUnit.NANOSECONDS);
        }

        @Override
        default public boolean await(long timeoutMillis) throws InterruptedException {
            return this.await(timeoutMillis, TimeUnit.MILLISECONDS);
        }

        @Override
        default public WithUnit toAwaitableWithUnit() {
            return this;
        }
    }
}

