package pl.michal.grzesiak.criticizer;

import javax.validation.Constraint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Stream;

class ValidationAnnotationChecker {

    private final ChildFieldsExtractor childFieldsExtractor;

    ValidationAnnotationChecker(ChildFieldsExtractor childFieldsExtractor) {
        this.childFieldsExtractor = childFieldsExtractor;
    }

    public boolean hasAnyChildValidationAnnotation(Field parent) {
        List<Field> children = childFieldsExtractor.getFieldsFrom(parent);
        return children.stream()
                .anyMatch(this::hasChildAnyValidation);
    }

    private boolean hasChildAnyValidation(Field field) {
        Annotation[] annotationsOnField = field.getAnnotations();
        return Stream.of(annotationsOnField)
                .map(Annotation::annotationType)
                .map(Class::getDeclaredAnnotations)
                .anyMatch(annotations -> Stream.of(annotations)
                        .anyMatch(annotation -> annotation.annotationType().equals(Constraint.class)));
    }
}
