/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import pl.matsuo.core.util.collection.Pair;

public class CollectionUtil {
    public static <F, T> List<T> map(Collection<? extends F> collection, Function<F, T> mapper) {
        ArrayList<T> resultList = new ArrayList<T>(collection.size());
        for (F element : collection) {
            resultList.add(mapper.apply(element));
        }
        return resultList;
    }

    public static <E> List<E> filter(Collection<E> collection, Predicate<E> condition) {
        ArrayList<E> resultList = new ArrayList<E>(collection.size());
        for (E element : collection) {
            if (!condition.test(element)) continue;
            resultList.add(element);
        }
        return resultList;
    }

    public static <E, F> List<F> filterMap(Collection<E> collection, Function<E, F> mapper) {
        ArrayList<F> resultList = new ArrayList<F>();
        for (E element : collection) {
            F mapped = mapper.apply(element);
            if (mapped == null) continue;
            resultList.add(mapped);
        }
        return resultList;
    }

    public static <E, F> List<F> filterMap(Collection<E> collection, Predicate<E> condition, Function<E, F> mapper) {
        ArrayList<F> resultList = new ArrayList<F>();
        for (E element : collection) {
            if (!condition.test(element)) continue;
            resultList.add(mapper.apply(element));
        }
        return resultList;
    }

    public static <E, F, G> Map<F, G> toMap(Collection<E> collection, Function<E, F> keyMapper, Function<E, G> valueMapper) {
        HashMap<F, G> resultMap = new HashMap<F, G>();
        for (E element : collection) {
            resultMap.put(keyMapper.apply(element), valueMapper.apply(element));
        }
        return resultMap;
    }

    public static <E, F> Map<E, F> toMap(Pair<E, F> ... entries) {
        HashMap<E, F> result = new HashMap<E, F>();
        for (Pair<E, F> entry : entries) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <E> E last(List<E> list) {
        return list.get(list.size() - 1);
    }

    public static <E> List<E> merge(Collection<Collection<E>> collections) {
        return CollectionUtil.flatMap(collections, Function.identity());
    }

    public static <E> List<E> removeNulls(Collection<E> collection) {
        return CollectionUtil.filterMap(collection, Function.identity());
    }

    public static Map<String, String> stringMap(String ... keyValues) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < keyValues.length / 2; ++i) {
            map.put(keyValues[2 * i], keyValues[2 * i + 1]);
        }
        return map;
    }

    public static <F, T> T fold(Collection<? extends F> list, T startValue, BiFunction<T, F, T> reducer) {
        T value = startValue;
        for (F item : list) {
            value = reducer.apply(value, item);
        }
        return value;
    }

    public static <F, T> List<T> flatMap(Collection<? extends F> collection, Function<F, Collection<T>> mapper) {
        ArrayList<T> resultList = new ArrayList<T>(collection.size());
        for (F element : collection) {
            resultList.addAll(mapper.apply(element));
        }
        return resultList;
    }

    public static <E> List<Pair<Integer, E>> indexed(Collection<E> collection) {
        int index = 0;
        ArrayList<Pair<Integer, Pair<Integer, E>>> result = new ArrayList<Pair<Integer, Pair<Integer, E>>>(collection.size());
        for (E e : collection) {
            result.add(Pair.pair(index, e));
            ++index;
        }
        return result;
    }

    public static List<Integer> range(Integer start, Integer end) {
        ArrayList<Integer> range = new ArrayList<Integer>();
        for (int i = start.intValue(); i < end; ++i) {
            range.add(i);
        }
        return range;
    }

    public static <E> E getFirst(Collection<E> collection, Predicate<E> condition) {
        for (E element : collection) {
            if (!condition.test(element)) continue;
            return element;
        }
        return null;
    }

    public static <E> Optional<E> findFirst(Collection<E> collection, Predicate<E> condition) {
        for (E element : collection) {
            if (!condition.test(element)) continue;
            return Optional.of(element);
        }
        return Optional.empty();
    }

    public static <E> boolean anyMatch(Collection<E> collection, Predicate<E> condition) {
        for (E element : collection) {
            if (!condition.test(element)) continue;
            return true;
        }
        return false;
    }

    public static <E> boolean allMatch(Collection<E> collection, Predicate<E> condition) {
        for (E element : collection) {
            if (condition.test(element)) continue;
            return false;
        }
        return true;
    }

    public static <E> boolean noneMatch(Collection<E> collection, Predicate<E> condition) {
        for (E element : collection) {
            if (!condition.test(element)) continue;
            return false;
        }
        return true;
    }
}

