/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.service.permission;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import pl.matsuo.core.model.user.Group;
import pl.matsuo.core.model.user.GroupEnum;
import pl.matsuo.core.model.user.User;
import pl.matsuo.core.service.permission.IPermissionService;
import pl.matsuo.core.service.permission.PermissionService;
import pl.matsuo.core.service.permission.model.Permissions;
import pl.matsuo.core.service.session.SessionState;
import pl.matsuo.core.test.data.TestSessionState;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes={PermissionService.class, TestSessionState.class})
public class TestPermissionService {
    @Autowired
    PermissionService permissionService;
    @Autowired
    SessionState sessionState;

    @Test
    public void testGetPermissions() {
        Permissions permissions = this.permissionService.getPermissions();
        Assert.assertNotNull((Object)permissions);
        Assert.assertNotNull((Object)permissions.getPermissions());
        Assert.assertFalse((boolean)permissions.getPermissions().isEmpty());
    }

    protected void configureSessionState(String groupName) {
        User user = new User();
        Group group = new Group();
        group.setName(groupName);
        user.getGroups().add(group);
        this.sessionState.setUser(user);
    }

    @Test
    public void testAdminPermissions() {
        this.configureSessionState(GroupEnum.ADMIN.name());
        Assert.assertTrue((boolean)this.permissionService.isPermitted("addAppointment"));
        Assert.assertTrue((boolean)this.permissionService.isPermitted("/reckonings/simple_test"));
        Assert.assertTrue((boolean)this.permissionService.isPermitted("xxx_yyy"));
    }

    @Test
    public void testPermissions() {
        this.configureSessionState("reckonings");
        Assert.assertFalse((boolean)this.permissionService.isPermitted("addAppointment"));
        Assert.assertTrue((boolean)this.permissionService.isPermitted("/reckonings/simple_test"));
        Assert.assertTrue((boolean)this.permissionService.isPermitted("/reckonings"));
        Assert.assertFalse((boolean)this.permissionService.isPermitted("xxx_yyy"));
    }

    @Test
    public void testPermissionsWithRestrictedRequestType() {
        this.configureSessionState("reckonings");
        Assert.assertFalse((boolean)this.permissionService.isPermitted("/reckonings/simple_test", IPermissionService.RequestType.POST));
        Assert.assertFalse((boolean)this.permissionService.isPermitted("xxx_yyy", IPermissionService.RequestType.POST));
    }

    @Test
    public void testPermissionMatching() {
        this.permissionService.matches("/reckonings/simple_test", "/reckonings/*");
    }

    @Test
    public void testPermissionResetAfterTime() {
        this.configureSessionState("reckonings");
        this.sessionState.setLastRequestTime(0L);
        Assert.assertFalse((boolean)this.permissionService.isPermitted("addAppointment"));
        Assert.assertFalse((boolean)this.permissionService.isPermitted("/reckonings/simple_test"));
        Assert.assertFalse((boolean)this.permissionService.isPermitted("xxx_yyy"));
        Assert.assertNull((Object)this.sessionState.getUser());
        Assert.assertTrue((boolean)this.sessionState.isInGroup(GroupEnum.GUEST.name()));
    }
}

