/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.test.data;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import pl.matsuo.core.model.query.Query;
import pl.matsuo.core.model.user.User;
import pl.matsuo.core.service.db.Database;
import pl.matsuo.core.service.session.SessionState;
import pl.matsuo.core.test.data.AbstractTestData;

@RunWith(value=MockitoJUnitRunner.class)
public class TestAbstractTestData {
    @Mock
    Database database;
    @Mock
    SessionState sessionState;
    @Spy
    @InjectMocks
    TestData testData;

    @Test
    public void testDataInDatabase() {
        User user = new User();
        user.setIdBucket(Integer.valueOf(17));
        Mockito.when((Object)this.database.findOne((Query)Mockito.any())).thenReturn((Object)user);
        this.testData.execute();
        Assert.assertTrue((boolean)this.testData.invoked);
        ((Database)Mockito.verify((Object)this.database)).findOne((Query)Mockito.any());
        ((SessionState)Mockito.verify((Object)this.sessionState)).setUser(user);
        ((SessionState)Mockito.verify((Object)this.sessionState)).setIdBucket(Integer.valueOf(17));
        ((SessionState)Mockito.verify((Object)this.sessionState)).setUser(null);
        ((SessionState)Mockito.verify((Object)this.sessionState)).setIdBucket(null);
    }

    public static class TestData
    extends AbstractTestData {
        public boolean invoked = false;

        public void execute() {
            this.withUser("admin", () -> {
                this.invoked = true;
            });
        }
    }
}

