/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.service.mail;

import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import pl.matsuo.core.model.AbstractEntity;
import pl.matsuo.core.model.message.MailMessage;
import pl.matsuo.core.service.db.Database;
import pl.matsuo.core.service.mail.MailService;
import pl.matsuo.core.service.print.IPrintsRendererService;

@RunWith(value=MockitoJUnitRunner.class)
public class TestMailService {
    @InjectMocks
    MailService mailService = new MailService();
    @Spy
    JavaMailSender mailSender = new JavaMailSenderImpl();
    @Mock
    Database database;
    @Mock
    IPrintsRendererService printsRendererService;

    public TestMailService() {
        this.mailService.database = this.database;
        this.mailService.mailSender = this.mailSender;
    }

    @Test
    public void testSendMail() throws Exception {
        MailMessage mailMessage = new MailMessage();
        mailMessage.setId(Integer.valueOf(55));
        ((JavaMailSender)Mockito.doAnswer(invocation -> null).when((Object)this.mailSender)).send((MimeMessage)Mockito.any(MimeMessage.class));
        Mockito.when((Object)this.database.create((AbstractEntity)Mockito.any(MailMessage.class))).thenReturn((Object)mailMessage);
        Mockito.when((Object)this.printsRendererService.renderHtml("bodyTemplate.ftl", null)).thenReturn((Object)"OK".getBytes());
        Assert.assertEquals((Object)55, (Object)this.mailService.sendMail(new InternetAddress("from@example.com"), new InternetAddress("to@example.com"), "subject", "bodyTemplate.ftl", null));
        ((JavaMailSender)Mockito.verify((Object)this.mailSender)).send((MimeMessage)Mockito.any(MimeMessage.class));
    }
}

