/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.service.login;

import javax.mail.internet.InternetAddress;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import pl.matsuo.core.AbstractDbTest;
import pl.matsuo.core.conf.GeneralConfig;
import pl.matsuo.core.conf.TestMailConfig;
import pl.matsuo.core.exception.UnauthorizedException;
import pl.matsuo.core.model.query.Query;
import pl.matsuo.core.model.query.QueryBuilder;
import pl.matsuo.core.model.query.condition.QueryPart;
import pl.matsuo.core.model.user.User;
import pl.matsuo.core.service.login.CreateAccountData;
import pl.matsuo.core.service.login.LoginData;
import pl.matsuo.core.service.login.LoginService;
import pl.matsuo.core.service.mail.IMailService;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes={LoginService.class, TestMailConfig.class, GeneralConfig.class})
public class TestLoginService
extends AbstractDbTest {
    @Autowired
    LoginService loginService;
    @Autowired
    IMailService mailService;

    @Test
    public void testLogin() throws Exception {
        LoginData loginData = new LoginData();
        loginData.setUsername("admin");
        loginData.setPassword("6%86P#WnukNp2gBm");
        Assert.assertEquals((Object)"admin", (Object)this.loginService.login(loginData));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mailService});
    }

    @Test(expected=UnauthorizedException.class)
    public void testIncorrectLogin() throws Exception {
        LoginData loginData = new LoginData();
        loginData.setUsername("admin");
        loginData.setPassword("xxx");
        this.loginService.login(loginData);
    }

    @Test
    public void testActivateAccount() throws Exception {
        CreateAccountData createAccountData = new CreateAccountData();
        createAccountData.setUsername("blicky2");
        createAccountData.setCompanyName("test2");
        createAccountData.setPassword("blickyPass2");
        String ticket = this.loginService.createAccount(createAccountData, false);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mailService});
        this.loginService.activateAccount(ticket);
        LoginData loginData = new LoginData();
        loginData.setUsername("blicky2");
        loginData.setPassword("blickyPass2");
        Assert.assertEquals((Object)"blicky2", (Object)this.loginService.login(loginData));
    }

    @Test
    public void testRemindPassword() throws Exception {
        this.loginService.remindPassword("admin");
        ((IMailService)Mockito.verify((Object)this.mailService)).sendMail((InternetAddress)Mockito.any(InternetAddress.class), (InternetAddress)Mockito.any(InternetAddress.class), Mockito.anyString(), Mockito.anyString(), Mockito.anyObject());
        Mockito.reset((Object[])new IMailService[]{this.mailService});
    }

    @Test
    public void testCreateAccount() throws Exception {
        CreateAccountData createAccountData = new CreateAccountData();
        createAccountData.setUsername("blicky");
        createAccountData.setCompanyName("test");
        createAccountData.setPassword("blickyPass");
        Mockito.when((Object)this.mailService.sendMail((InternetAddress)Mockito.any(InternetAddress.class), (InternetAddress)Mockito.any(InternetAddress.class), Mockito.anyString(), Mockito.anyString(), Mockito.anyObject())).then(invocation -> {
            InternetAddress address = (InternetAddress)invocation.getArgumentAt(1, InternetAddress.class);
            Assert.assertEquals((Object)"blicky", (Object)address.getAddress());
            return null;
        });
        String ticket = this.loginService.createAccount(createAccountData, true);
        User blicky = (User)this.database.findOne((Query)QueryBuilder.query(User.class, (QueryPart[])new QueryPart[]{QueryBuilder.eq(User::getUsername, (Object)"blicky")}));
        Assert.assertEquals((Object)ticket, (Object)blicky.getUnblockTicket());
        ((IMailService)Mockito.verify((Object)this.mailService)).sendMail((InternetAddress)Mockito.any(InternetAddress.class), (InternetAddress)Mockito.any(InternetAddress.class), Mockito.anyString(), Mockito.anyString(), Mockito.anyObject());
        Mockito.reset((Object[])new IMailService[]{this.mailService});
    }
}

