/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.service.facade;

import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.matsuo.core.service.facade.FacadeBuilder;
import pl.matsuo.core.service.facade.PrintTestFacade;
import pl.matsuo.core.service.facade.PrintTestSubFacade;
import pl.matsuo.core.service.parameterprovider.IParameterProvider;
import pl.matsuo.core.util.DateUtil;
import pl.matsuo.core.util.NumberUtil;
import pl.matsuo.core.util.ReflectUtil;
import pl.matsuo.core.util.collection.CollectionUtil;

public class TestFacadeBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TestFacadeBuilder.class);
    private final FacadeBuilder facadeBuilder = new FacadeBuilder();
    private final Map print = new HashMap();
    private final PrintTestFacade facade = (PrintTestFacade)this.facadeBuilder.createFacade((Object)this.print, PrintTestFacade.class);

    @After
    public void logPrintState() {
        logger.info(this.print.toString());
    }

    @Test
    public void testIntegerReadWrite() throws Exception {
        this.facade.setInteger(7);
        Assert.assertEquals((Object)7, (Object)this.facade.getInteger());
    }

    @Test
    public void testStringReadWrite() throws Exception {
        this.facade.setString("test");
        Assert.assertEquals((Object)"test", (Object)this.facade.getString());
    }

    @Test
    public void testDateReadWrite() throws Exception {
        this.facade.setDate(DateUtil.date((int)2013, (int)4, (int)4));
        Assert.assertEquals((Object)DateUtil.date((int)2013, (int)4, (int)4), (Object)this.facade.getDate());
    }

    @Test
    public void testBigDecimalReadWrite() throws Exception {
        this.facade.setBigDecimal(NumberUtil.bd((String)"700.43"));
        Assert.assertEquals((Object)NumberUtil.bd((String)"700.43"), (Object)this.facade.getBigDecimal());
    }

    @Test
    public void testBooleanReadWrite() throws Exception {
        this.facade.setBoolean(true);
        Assert.assertTrue((boolean)this.facade.getBoolean());
        this.facade.setBoolean(false);
        Assert.assertFalse((boolean)this.facade.getBoolean());
    }

    @Test
    public void testSubEntity() throws Exception {
        PrintTestSubFacade subEntity = this.facade.getSubEntity();
        this.facade.setBigDecimal(NumberUtil.bd((String)"0.00"));
        subEntity.setBigDecimal(NumberUtil.bd((String)"333"));
        subEntity.setSubBigDecimal(NumberUtil.bd((String)"700.43"));
        Assert.assertEquals((Object)NumberUtil.bd((String)"333"), (Object)subEntity.getBigDecimal());
        Assert.assertEquals((Object)NumberUtil.bd((String)"700.43"), (Object)subEntity.getSubBigDecimal());
        Assert.assertEquals((Object)NumberUtil.bd((String)"0.00"), (Object)this.facade.getBigDecimal());
        Assert.assertEquals((Object)NumberUtil.bd((String)"333"), this.print.get("subEntity.bigDecimal"));
        Assert.assertEquals((Object)NumberUtil.bd((String)"700.43"), this.print.get("subEntity.subBigDecimal"));
        Assert.assertEquals((Object)NumberUtil.bd((String)"0.00"), this.print.get("bigDecimal"));
    }

    @Test
    public void testCreateParameterProvider() throws Exception {
        IParameterProvider parameterProvider = this.facadeBuilder.createParameterProvider((Object)CollectionUtil.stringMap((String[])new String[]{"1", "one", "2", "two"}));
        Assert.assertEquals((Object)"one", (Object)parameterProvider.get("1"));
        Assert.assertEquals((Object)"two", (Object)parameterProvider.get("2"));
    }

    @Test
    public void testInitializeProviders() throws Exception {
        this.facadeBuilder.initializeProviders();
        Map parameterProviders = (Map)ReflectUtil.getValue((Object)this.facadeBuilder, (String)"parameterProviders");
        Assert.assertEquals((long)2L, (long)parameterProviders.size());
    }
}

