/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.kv;

import javax.persistence.EnumType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.matsuo.core.kv.ITestKeyValueFacade;
import pl.matsuo.core.kv.TestKeyValueSubEntity;
import pl.matsuo.core.model.kv.KeyValueEntity;
import pl.matsuo.core.service.facade.FacadeBuilder;
import pl.matsuo.core.service.parameterprovider.KeyValueParameterProvider;
import pl.matsuo.core.util.DateUtil;
import pl.matsuo.core.util.NumberUtil;

public class TestKeyValueFacadeBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TestKeyValueFacadeBuilder.class);
    private final FacadeBuilder facadeBuilder = new FacadeBuilder();
    private final TestKeyValueSubEntity keyValueEntity = new TestKeyValueSubEntity();
    private final ITestKeyValueFacade facade = (ITestKeyValueFacade)this.facadeBuilder.createFacade((Object)new KeyValueParameterProvider((KeyValueEntity)this.keyValueEntity), ITestKeyValueFacade.class);

    @After
    public void logPrintState() {
        logger.info(this.keyValueEntity.getFields().toString());
    }

    @Test
    public void testIntegerReadWrite() throws Exception {
        this.facade.setInteger(7);
        Assert.assertEquals((Object)7, (Object)this.facade.getInteger());
    }

    @Test
    public void testEnumReadWrite() throws Exception {
        this.facade.setEnumType(EnumType.STRING);
        Assert.assertEquals((Object)EnumType.STRING, (Object)this.facade.getEnumType());
    }

    @Test
    public void testStringReadWrite() throws Exception {
        this.facade.setString("test");
        Assert.assertEquals((Object)"test", (Object)this.facade.getString());
    }

    @Test
    public void testDateReadWrite() throws Exception {
        this.facade.setDate(DateUtil.date((int)2013, (int)4, (int)4));
        Assert.assertEquals((Object)DateUtil.date((int)2013, (int)4, (int)4), (Object)this.facade.getDate());
    }

    @Test
    public void testBigDecimalReadWrite() throws Exception {
        this.facade.setBigDecimal(NumberUtil.bd((String)"700.43"));
        Assert.assertEquals((Object)NumberUtil.bd((String)"700.43"), (Object)this.facade.getBigDecimal());
    }

    @Test
    public void tesDoubleToInteger() throws Exception {
        this.facade.setDoubleToInteger(7.3);
        Assert.assertEquals((Object)7, (Object)this.facade.getDoubleToInteger());
    }

    @Test
    public void testDoubleToBigDecimal() throws Exception {
        this.facade.setDoubleToBigDecimal(7.7);
        Assert.assertEquals((Object)NumberUtil.bd((String)"7.7"), (Object)this.facade.getDoubleToBigDecimal());
    }

    @Test
    public void testElements() throws Exception {
        this.keyValueEntity.getInternalElements().add(new TestKeyValueSubEntity());
        ITestKeyValueFacade keyValueElementFacade = this.facade.getInternalElements().get(0);
        keyValueElementFacade.setString("test2");
        Assert.assertEquals((Object)"test2", (Object)keyValueElementFacade.getString());
    }
}

