/*
 * Decompiled with CFR 0.152.
 */
package pl.matsuo.core.db;

import java.util.List;
import javax.transaction.Transactional;
import org.hibernate.Interceptor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import pl.matsuo.core.conf.DbConfig;
import pl.matsuo.core.model.AbstractEntity;
import pl.matsuo.core.model.api.Initializer;
import pl.matsuo.core.model.query.Query;
import pl.matsuo.core.model.query.QueryBuilder;
import pl.matsuo.core.model.query.condition.QueryPart;
import pl.matsuo.core.model.user.Group;
import pl.matsuo.core.service.db.Database;
import pl.matsuo.core.service.db.EntityInterceptorService;
import pl.matsuo.core.service.db.interceptor.AuditTrailInterceptor;
import pl.matsuo.core.service.db.interceptor.IdBucketInterceptor;
import pl.matsuo.core.test.data.TestSessionState;
import pl.matsuo.core.util.ReflectUtil;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes={DbConfig.class, TestSessionState.class})
public class TestDatabase {
    @Autowired
    protected Database database;
    @Autowired
    protected EntityInterceptorService entityInterceptorService;

    @Test
    public void testEntityInterceptor() throws Exception {
        List interceptors = (List)ReflectUtil.getValue((Object)this.entityInterceptorService, (String)"interceptors");
        Assert.assertEquals((long)2L, (long)interceptors.size());
        boolean containsAuditTrailInterceptor = false;
        boolean containsIdBucketInterceptor = false;
        for (Interceptor interceptor : interceptors) {
            containsAuditTrailInterceptor = containsAuditTrailInterceptor || interceptor.getClass().equals(AuditTrailInterceptor.class);
            containsIdBucketInterceptor = containsIdBucketInterceptor || interceptor.getClass().equals(IdBucketInterceptor.class);
        }
        Assert.assertTrue((boolean)containsAuditTrailInterceptor);
        Assert.assertTrue((boolean)containsIdBucketInterceptor);
    }

    @Test
    @Transactional
    public void testBasicDatabaseOperations() throws Exception {
        Group group = new Group();
        group.setName("test-group");
        this.database.create((AbstractEntity)group);
        Assert.assertNotNull((Object)group.getId());
        List groups = this.database.find((Query)QueryBuilder.query(Group.class, (QueryPart[])new QueryPart[0]));
        Assert.assertTrue((boolean)groups.contains(group));
        groups = this.database.findAll(Group.class, new Initializer[0]);
        Assert.assertTrue((boolean)groups.contains(group));
        group = (Group)this.database.findOne((Query)QueryBuilder.query(Group.class, (QueryPart[])new QueryPart[]{QueryBuilder.eq(Group::getName, (Object)"test-group")}));
        Assert.assertNotNull((Object)group);
        group = (Group)this.database.findById(Group.class, group.getId(), new Initializer[0]);
        Assert.assertNotNull((Object)group);
        group.setName("test-group-2");
        this.database.update((AbstractEntity)group);
        Assert.assertNull((Object)this.database.findOne((Query)QueryBuilder.query(Group.class, (QueryPart[])new QueryPart[]{QueryBuilder.eq(Group::getName, (Object)"test-group")})));
        Assert.assertNotNull((Object)this.database.findOne((Query)QueryBuilder.query(Group.class, (QueryPart[])new QueryPart[]{QueryBuilder.eq(Group::getName, (Object)"test-group-2")})));
        this.database.delete((AbstractEntity)group);
        Assert.assertNull((Object)this.database.findOne((Query)QueryBuilder.query(Group.class, (QueryPart[])new QueryPart[]{QueryBuilder.eq(Group::getName, (Object)"test-group")})));
        Assert.assertNull((Object)this.database.findOne((Query)QueryBuilder.query(Group.class, (QueryPart[])new QueryPart[]{QueryBuilder.eq(Group::getName, (Object)"test-group-2")})));
    }
}

