/*
 * Decompiled with CFR 0.152.
 */
package pl.kubie.fluentmocks.common;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;

public final class PathParamsValidator {
    private static final Pattern PATH_PARAM_PATTERN = Pattern.compile("\\{([^/}]+)}");

    public static void validatePathParams(Set<String> pathParams, String url) {
        Set<String> missingParams = PathParamsValidator.missingParams(url, pathParams);
        if (!missingParams.isEmpty()) {
            throw new IllegalArgumentException("Missing value for path parameter(s) " + String.valueOf(missingParams) + " in URL template '" + url + "'");
        }
    }

    public static Set<String> missingParams(String url, Collection<String> pathParams) {
        return PathParamsValidator.urlParamNames(url).stream().filter(it -> !pathParams.contains(it)).collect(Collectors.toSet());
    }

    public static Set<String> urlParamNames(String url) {
        Matcher matcher = PATH_PARAM_PATTERN.matcher(url);
        HashSet<String> result = new HashSet<String>();
        while (matcher.find()) {
            result.add(matcher.group(1));
        }
        return result;
    }

    @Generated
    private PathParamsValidator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

