/*
 * Decompiled with CFR 0.152.
 */
package pl.kubie.fluentmocks.common;

import java.nio.charset.StandardCharsets;
import lombok.Generated;
import pl.kubie.fluentmocks.common.FileLoader;
import pl.kubie.fluentmocks.common.JsonPayload;
import pl.kubie.fluentmocks.common.JsonSerializer;
import pl.kubie.fluentmocks.common.PayloadFormat;
import pl.kubie.fluentmocks.http.api.http.body.FileBody;
import pl.kubie.fluentmocks.http.api.http.body.JsonBody;
import pl.kubie.fluentmocks.http.api.http.body.RawBody;
import pl.kubie.fluentmocks.http.api.response.ResponseBody;

public class AbstractResponseBody
implements ResponseBody,
JsonBody<ResponseBody>,
FileBody<ResponseBody>,
RawBody<ResponseBody> {
    private final FileLoader fileLoader;
    private final JsonSerializer serializer;
    protected byte[] bytes;
    protected PayloadFormat format = PayloadFormat.EMPTY;

    public FileBody<ResponseBody> file(String path) {
        this.bytes = this.fileLoader.load(path);
        return this;
    }

    public RawBody<ResponseBody> raw(byte[] payload) {
        this.bytes = payload;
        this.format = PayloadFormat.RAW_BYTES;
        return this;
    }

    public JsonBody<ResponseBody> json(byte[] payload) {
        this.bytes = payload;
        this.format = PayloadFormat.JSON;
        return this;
    }

    public RawBody<ResponseBody> raw(String payload) {
        this.bytes = payload.getBytes(StandardCharsets.UTF_8);
        this.format = PayloadFormat.RAW;
        return this;
    }

    public JsonBody<ResponseBody> json(Object payload) {
        return this.json(this.serializer.toJson(payload));
    }

    public JsonBody<ResponseBody> json(String payload) {
        return this.json(payload.getBytes(StandardCharsets.UTF_8));
    }

    public JsonBody<ResponseBody> override(String jsonPath, String json) {
        this.bytes = JsonPayload.overrideJson(this.bytes, StandardCharsets.UTF_8, jsonPath, json);
        return this;
    }

    public JsonBody<ResponseBody> override(String jsonPath, Object object) {
        return this.override(jsonPath, this.serializer.toJson(object));
    }

    public JsonBody<ResponseBody> json() {
        return this.json(this.bytes);
    }

    public RawBody<ResponseBody> raw() {
        return this.raw(this.bytes);
    }

    @Generated
    public AbstractResponseBody(FileLoader fileLoader, JsonSerializer serializer) {
        this.fileLoader = fileLoader;
        this.serializer = serializer;
    }
}

