/*
 * Decompiled with CFR 0.152.
 */
package pl.joegreen.lambdaFromString.classFactory;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import pl.joegreen.lambdaFromString.classFactory.CompiledClassJavaObject;

class InMemoryFileManager
extends ForwardingJavaFileManager<StandardJavaFileManager>
implements StandardJavaFileManager {
    private Map<String, CompiledClassJavaObject> classes = new HashMap<String, CompiledClassJavaObject>();

    protected InMemoryFileManager(StandardJavaFileManager fileManager) {
        super(fileManager);
    }

    public Map<String, CompiledClassJavaObject> getClasses() {
        return new HashMap<String, CompiledClassJavaObject>(this.classes);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (kind == JavaFileObject.Kind.CLASS) {
            this.classes.putIfAbsent(className, new CompiledClassJavaObject(className));
            return this.classes.get(className);
        }
        throw new IOException(this.getClass().getSimpleName() + " cannot open files for writing. " + "Only .class output is supported and stored in memory.");
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
        return ((StandardJavaFileManager)this.fileManager).getJavaFileObjectsFromFiles(files);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... files) {
        return ((StandardJavaFileManager)this.fileManager).getJavaFileObjects(files);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> names) {
        return ((StandardJavaFileManager)this.fileManager).getJavaFileObjectsFromStrings(names);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... names) {
        return ((StandardJavaFileManager)this.fileManager).getJavaFileObjects(names);
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends File> path) throws IOException {
        ((StandardJavaFileManager)this.fileManager).setLocation(location, path);
    }

    @Override
    public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
        return ((StandardJavaFileManager)this.fileManager).getLocation(location);
    }
}

