/*
 * Decompiled with CFR 0.152.
 */
package pl.joegreen.lambdaFromString;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.JavaCompiler;
import pl.joegreen.lambdaFromString.ClassPathExtractor;
import pl.joegreen.lambdaFromString.DefaultHelperClassSourceProvider;
import pl.joegreen.lambdaFromString.HelperClassSourceProvider;
import pl.joegreen.lambdaFromString.JavaCompilerProvider;
import pl.joegreen.lambdaFromString.classFactory.ClassFactory;
import pl.joegreen.lambdaFromString.classFactory.DefaultClassFactory;

public class LambdaFactoryConfiguration {
    protected static Optional<JavaCompiler> DEFAULT_COMPILER = JavaCompilerProvider.findDefaultJavaCompiler();
    private HelperClassSourceProvider helperClassSourceProvider = new DefaultHelperClassSourceProvider();
    private ClassFactory classFactory = new DefaultClassFactory();
    private List<String> staticImports = Collections.unmodifiableList(new ArrayList());
    private List<String> imports = Collections.unmodifiableList(new ArrayList());
    private String compilationClassPath = ClassPathExtractor.getJavaPropertyClassPath();
    private ClassLoader parentClassLoader = this.getClass().getClassLoader();
    private JavaCompiler javaCompiler = DEFAULT_COMPILER.orElse(null);

    public static LambdaFactoryConfiguration get() {
        return new LambdaFactoryConfiguration();
    }

    private LambdaFactoryConfiguration() {
    }

    private LambdaFactoryConfiguration copy() {
        return new LambdaFactoryConfiguration().setDefaultHelperClassSourceProvider(this.helperClassSourceProvider).setClassFactory(this.classFactory).setStaticImports(this.staticImports).setImports(this.imports).setCompilationClassPath(this.compilationClassPath).setParentClassLoader(this.parentClassLoader).setJavaCompiler(this.javaCompiler);
    }

    public HelperClassSourceProvider getDefaultHelperClassSourceProvider() {
        return this.helperClassSourceProvider;
    }

    public ClassFactory getClassFactory() {
        return this.classFactory;
    }

    public List<String> getStaticImports() {
        return this.staticImports;
    }

    public List<String> getImports() {
        return this.imports;
    }

    public String getCompilationClassPath() {
        return this.compilationClassPath;
    }

    public ClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public JavaCompiler getJavaCompiler() {
        return this.javaCompiler;
    }

    public LambdaFactoryConfiguration withHelperClassSourceProvider(HelperClassSourceProvider helperSourceProvider) {
        return this.copy().setDefaultHelperClassSourceProvider(helperSourceProvider);
    }

    public LambdaFactoryConfiguration withClassFactory(ClassFactory classFactory) {
        return this.copy().setClassFactory(classFactory);
    }

    public LambdaFactoryConfiguration withStaticImports(String ... newStaticImports) {
        return this.copy().setStaticImports(LambdaFactoryConfiguration.listWithNewElements(this.staticImports, newStaticImports));
    }

    public LambdaFactoryConfiguration withImports(String ... newImports) {
        return this.copy().setImports(LambdaFactoryConfiguration.listWithNewElements(this.imports, newImports));
    }

    public LambdaFactoryConfiguration withImports(Class<?> ... newImports) {
        String[] stringImports = (String[])Arrays.stream(newImports).map(Class::getCanonicalName).toArray(String[]::new);
        return this.withImports(stringImports);
    }

    public LambdaFactoryConfiguration withCompilationClassPath(String compilationClassPath) {
        return this.copy().setCompilationClassPath(compilationClassPath);
    }

    public LambdaFactoryConfiguration withParentClassLoader(ClassLoader parentClassLoader) {
        return this.copy().setParentClassLoader(parentClassLoader);
    }

    public LambdaFactoryConfiguration withJavaCompiler(JavaCompiler javaCompiler) {
        return this.copy().setJavaCompiler(javaCompiler);
    }

    private LambdaFactoryConfiguration setDefaultHelperClassSourceProvider(HelperClassSourceProvider helperClassSourceProvider) {
        this.helperClassSourceProvider = helperClassSourceProvider;
        return this;
    }

    private LambdaFactoryConfiguration setClassFactory(ClassFactory classFactory) {
        this.classFactory = classFactory;
        return this;
    }

    private LambdaFactoryConfiguration setStaticImports(List<String> staticImports) {
        this.staticImports = staticImports;
        return this;
    }

    private LambdaFactoryConfiguration setImports(List<String> imports) {
        this.imports = imports;
        return this;
    }

    private LambdaFactoryConfiguration setCompilationClassPath(String classPath) {
        this.compilationClassPath = classPath;
        return this;
    }

    private LambdaFactoryConfiguration setParentClassLoader(ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
        return this;
    }

    private LambdaFactoryConfiguration setJavaCompiler(JavaCompiler javaCompiler) {
        this.javaCompiler = javaCompiler;
        return this;
    }

    private static <T> List<T> listWithNewElements(List<T> oldList, T ... newElements) {
        return Collections.unmodifiableList(Stream.concat(oldList.stream(), Arrays.stream(newElements)).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LambdaFactoryConfiguration that = (LambdaFactoryConfiguration)o;
        if (!this.helperClassSourceProvider.equals(that.helperClassSourceProvider)) {
            return false;
        }
        if (!this.classFactory.equals(that.classFactory)) {
            return false;
        }
        if (!this.staticImports.equals(that.staticImports)) {
            return false;
        }
        if (!this.imports.equals(that.imports)) {
            return false;
        }
        if (!this.compilationClassPath.equals(that.compilationClassPath)) {
            return false;
        }
        if (!this.parentClassLoader.equals(that.parentClassLoader)) {
            return false;
        }
        return this.javaCompiler.equals(that.javaCompiler);
    }

    public int hashCode() {
        int result = this.helperClassSourceProvider.hashCode();
        result = 31 * result + this.classFactory.hashCode();
        result = 31 * result + this.staticImports.hashCode();
        result = 31 * result + this.imports.hashCode();
        result = 31 * result + this.compilationClassPath.hashCode();
        result = 31 * result + this.parentClassLoader.hashCode();
        result = 31 * result + this.javaCompiler.hashCode();
        return result;
    }
}

