/*
 * Decompiled with CFR 0.152.
 */
package pl.joegreen.lambdaFromString.classFactory;

import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import pl.joegreen.lambdaFromString.classFactory.ClassCompilationException;
import pl.joegreen.lambdaFromString.classFactory.ClassFactory;
import pl.joegreen.lambdaFromString.classFactory.ClassSourceJavaObject;
import pl.joegreen.lambdaFromString.classFactory.CompilationDetails;
import pl.joegreen.lambdaFromString.classFactory.CompiledClassJavaObject;
import pl.joegreen.lambdaFromString.classFactory.InMemoryClassLoader;
import pl.joegreen.lambdaFromString.classFactory.InMemoryFileManager;

public class DefaultClassFactory
implements ClassFactory {
    @Override
    public Class<?> createClass(String fullClassName, String sourceCode, JavaCompiler compiler) throws ClassCompilationException {
        try {
            Map<String, CompiledClassJavaObject> compiledClassesBytes = this.compileClasses(fullClassName, sourceCode, compiler);
            return this.loadClass(fullClassName, compiledClassesBytes);
        }
        catch (ClassNotFoundException | RuntimeException e) {
            throw new ClassCompilationException(e);
        }
    }

    protected Class<?> loadClass(String fullClassName, Map<String, CompiledClassJavaObject> compiledClassesBytes) throws ClassNotFoundException {
        return new InMemoryClassLoader(compiledClassesBytes).loadClass(fullClassName);
    }

    protected Map<String, CompiledClassJavaObject> compileClasses(String fullClassName, String sourceCode, JavaCompiler compiler) throws ClassCompilationException {
        ClassSourceJavaObject classSourceObject = new ClassSourceJavaObject(fullClassName, sourceCode);
        try (InMemoryFileManager stdFileManager = new InMemoryFileManager(compiler.getStandardFileManager(null, null, null));){
            StringWriter stdErrWriter = new StringWriter();
            DiagnosticCollector diagnosticsCollector = new DiagnosticCollector();
            JavaCompiler.CompilationTask compilationTask = compiler.getTask(stdErrWriter, stdFileManager, diagnosticsCollector, this.getDefaultCompilerOptions(), null, Collections.singletonList(classSourceObject));
            boolean status = compilationTask.call();
            if (!status) {
                throw new ClassCompilationException(new CompilationDetails(fullClassName, sourceCode, diagnosticsCollector.getDiagnostics(), stdErrWriter.toString()));
            }
            Map<String, CompiledClassJavaObject> map = stdFileManager.getClasses();
            return map;
        }
    }

    protected List<String> getDefaultCompilerOptions() {
        return Arrays.asList("-target", "1.8", "-source", "1.8");
    }
}

