/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.coderules.archunit;

import com.querydsl.core.types.dsl.EntityPathBase;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.junit.ArchTest;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenFieldsConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenMethodsConjunction;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.MappedSuperclass;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RestController;

public class MandatoryAnnotationArchRules {
    private static final String ENUM_NOT_ANNOTATED_MSG_FORMAT = "Field '%s' in class: '%s' not annotated with @Enumerated(EnumType.STRING)";
    private static final String CLASS_NOT_ANNOTATED_SERVICE_MSG = "class '%s' not annotated with @Service or with other other annotation which it contains";
    @ArchTest
    public final ArchRule facadeShouldBeAnnotatedWithTransactionalAndValidatedAnnotation = ((GivenClassesConjunction)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveSimpleNameEndingWith("Facade")).and().doNotHaveModifier(JavaModifier.ABSTRACT)).should().beAnnotatedWith(Transactional.class).andShould().beAnnotatedWith(Validated.class);
    @ArchTest
    public final ArchRule serviceShouldBeAnnotatedWithValidatedAnnotation = ((GivenClassesConjunction)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveSimpleNameEndingWith("Facade")).and().doNotHaveModifier(JavaModifier.ABSTRACT)).should().beAnnotatedWith(Validated.class);
    @ArchTest
    public final ArchRule controllerShouldNotBeAnnotatedWithValidatedAnnotation = ((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveSimpleNameEndingWith("RestController")).should().notBeAnnotatedWith(Validated.class);
    @ArchTest
    public final ArchRule controllerShouldBeAnnotatedWithApiAnnotation = ((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveSimpleNameEndingWith("RestController")).should().beAnnotatedWith(Api.class);
    @ArchTest
    public final ArchRule publicControllerMethodsShouldBeAnnotatedWithApiOperationAnnotation = ((GivenMethodsConjunction)((GivenMethodsConjunction)ArchRuleDefinition.methods().that().areDeclaredInClassesThat().haveSimpleNameEndingWith("RestController")).and().haveModifier(JavaModifier.PUBLIC)).should().beAnnotatedWith(ApiOperation.class);
    @ArchTest
    public final ArchRule restControllersShouldBeAnnotatedWithRestControllerAnnotation = ((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveSimpleNameEndingWith("RestController")).should().beAnnotatedWith(RestController.class);
    @ArchTest
    public final ArchRule restControllersShouldHasRestControllerSuffix = ((GivenClassesConjunction)ArchRuleDefinition.classes().that().areAnnotatedWith(RestController.class)).should().haveSimpleNameEndingWith("RestController");
    @ArchTest
    public final ArchRule repositoriesShouldBeAnnotatedWithRepositoryAnnotation = ((GivenClassesConjunction)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveSimpleNameEndingWith("Repository")).and().areNotAnnotatedWith(NoRepositoryBean.class)).should().beAnnotatedWith(Repository.class);
    @ArchTest
    public final ArchRule entitiesShouldBeAnnotatedWithEntityAnnotation = ((GivenClassesConjunction)((GivenClassesConjunction)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveSimpleNameEndingWith("Entity")).and().areNotAssignableTo(EntityPathBase.class)).and().areNotAnnotatedWith(MappedSuperclass.class)).should().beAnnotatedWith(Entity.class);
    @ArchTest
    public final ArchRule servicesShouldBeAnnotatedWithServiceAnnotation = ((GivenClassesConjunction)((GivenClassesConjunction)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveSimpleNameEndingWith("Service")).and().areNotInterfaces()).and().doNotHaveModifier(JavaModifier.ABSTRACT)).should().notBeAnnotatedWith(Service.class).orShould(SHOULD_BE_ANNOTATE_WITH_SERVICE);
    @ArchTest
    public final ArchRule enumFieldsInEntitiesShouldBeEnumeratedByString = ((GivenFieldsConjunction)((GivenFieldsConjunction)ArchRuleDefinition.fields().that(IS_ENUM_TYPE).and().areDeclaredInClassesThat().haveSimpleNameEndingWith("Entity")).and().areDeclaredInClassesThat().areAnnotatedWith(Entity.class)).should(BE_ENUMERATED_WITH_STRING);
    private static final DescribedPredicate<JavaField> IS_ENUM_TYPE = new DescribedPredicate<JavaField>("is enum type", new Object[0]){

        public boolean apply(JavaField input) {
            return input.getRawType().isEnum();
        }
    };
    private static final ArchCondition<JavaField> BE_ENUMERATED_WITH_STRING = new ArchCondition<JavaField>("be annotated with @Enumerated(EnumType.STRING", new Object[0]){

        public void check(JavaField item, ConditionEvents events) {
            Set annotations = item.getAnnotations();
            String fieldName = item.getName();
            String ownerName = item.getOwner().getName();
            String msg = String.format(MandatoryAnnotationArchRules.ENUM_NOT_ANNOTATED_MSG_FORMAT, fieldName, ownerName);
            Optional<JavaAnnotation> foundEnumerated = annotations.stream().filter(it -> Enumerated.class.getCanonicalName().equals(it.getRawType().getFullName())).findFirst();
            if (foundEnumerated.isPresent()) {
                Object enumType = foundEnumerated.get().getProperties().get("value");
                if (EnumType.STRING.name().equals(enumType)) {
                    events.add((ConditionEvent)new SimpleConditionEvent((Object)item, false, msg));
                }
            } else {
                events.add((ConditionEvent)new SimpleConditionEvent((Object)item, false, msg));
            }
        }
    };
    private static final ArchCondition<JavaClass> SHOULD_BE_ANNOTATE_WITH_SERVICE = new ArchCondition<JavaClass>("be annotated with @Service or with other annotation witch contains it", new Object[0]){

        public void check(JavaClass javaClass, ConditionEvents conditionEvents) {
            Set annotations = javaClass.getAnnotations();
            AtomicReference<Boolean> found = new AtomicReference<Boolean>(false);
            this.searchForServiceAnnotation(annotations, found);
            if (!found.get().booleanValue()) {
                conditionEvents.add((ConditionEvent)new SimpleConditionEvent((Object)javaClass, false, String.format(MandatoryAnnotationArchRules.CLASS_NOT_ANNOTATED_SERVICE_MSG, javaClass.getFullName())));
                throw new IllegalArgumentException("");
            }
        }

        private void searchForServiceAnnotation(Set<JavaAnnotation<JavaClass>> annotations, AtomicReference<Boolean> found) {
            for (JavaAnnotation<JavaClass> annotation : annotations) {
                if (annotation.getRawType().getFullName().equals(Service.class.getCanonicalName())) {
                    found.set(true);
                    break;
                }
                this.searchForServiceAnnotation(annotation.getRawType().getAnnotations(), found);
            }
        }
    };
}

