/*
 * Decompiled with CFR 0.152.
 */
package pl.iterators.baklava.routes;

import com.typesafe.config.Config;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.parser.OpenAPIV3Parser;
import java.io.Serializable;
import org.apache.pekko.http.scaladsl.marshalling.Marshaller$;
import org.apache.pekko.http.scaladsl.marshalling.ToResponseMarshallable$;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.HttpResponse$;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.headers.Location;
import org.apache.pekko.http.scaladsl.server.ConjunctionMagnet$;
import org.apache.pekko.http.scaladsl.server.Directive;
import org.apache.pekko.http.scaladsl.server.Directive$;
import org.apache.pekko.http.scaladsl.server.Directives$;
import org.apache.pekko.http.scaladsl.server.RequestContext;
import org.apache.pekko.http.scaladsl.server.RouteResult;
import org.apache.pekko.http.scaladsl.server.directives.ContentTypeResolver$;
import org.apache.pekko.http.scaladsl.server.directives.Credentials;
import org.apache.pekko.http.scaladsl.server.directives.RouteDirectives$;
import org.apache.pekko.http.scaladsl.server.util.ApplyConverter$;
import org.apache.pekko.http.scaladsl.server.util.TupleOps;
import org.webjars.WebJarAssetLocator;
import pl.iterators.baklava.routes.BaklavaRoutes;
import pl.iterators.baklava.routes.BaklavaRoutes$Config$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Future;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.jdk.CollectionConverters$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class BaklavaRoutes$ {
    public static final BaklavaRoutes$ MODULE$ = new BaklavaRoutes$();
    private static Function1<RequestContext, Future<RouteResult>> swaggerWebJar;
    private static final String swaggerVersion;
    private static volatile boolean bitmap$0;

    static {
        swaggerVersion = "5.17.11";
    }

    private String swaggerVersion() {
        return swaggerVersion;
    }

    public Function1<RequestContext, Future<RouteResult>> routes(Config config) {
        BaklavaRoutes.Config internalConfig = BaklavaRoutes$Config$.MODULE$.apply(config);
        if (internalConfig.enabled()) {
            return (Function1)Directive$.MODULE$.addDirectiveApply((Directive)Directives$.MODULE$.authenticateBasic("docs", (Function1 & Serializable)credentials -> MODULE$.basicAuthOpt((Credentials)credentials, internalConfig)), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)x$1 -> Directives$.MODULE$._enhanceRouteWithConcatenation(Directives$.MODULE$._enhanceRouteWithConcatenation(Directives$.MODULE$._enhanceRouteWithConcatenation((Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.path(Directives$.MODULE$._segmentStringToPathMatcher("openapi"))).apply((Function0 & Serializable)() -> Directives$.MODULE$.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)MODULE$.openApiFileContent(internalConfig), Marshaller$.MODULE$.liftMarshaller(Marshaller$.MODULE$.StringMarshaller()))))).$tilde((Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)Directives$.MODULE$.path(Directives$.MODULE$._segmentStringToPathMatcher("swagger-ui").$div(Directives$.MODULE$._segmentStringToPathMatcher(MODULE$.swaggerVersion()), TupleOps.Join$.MODULE$.join0P()).$div(Directives$.MODULE$._segmentStringToPathMatcher("swagger-initializer.js"), TupleOps.Join$.MODULE$.join0P())).$amp(ConjunctionMagnet$.MODULE$.fromDirective(Directives$.MODULE$.get(), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable)() -> Directives$.MODULE$.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)MODULE$.swaggerInitializerContent(internalConfig), Marshaller$.MODULE$.liftMarshaller(Marshaller$.MODULE$.StringMarshaller())))))).$tilde((Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.pathPrefix(Directives$.MODULE$._segmentStringToPathMatcher("swagger-ui"))).apply((Function0 & Serializable)() -> MODULE$.swaggerWebJar()))).$tilde((Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.pathPrefix(Directives$.MODULE$._segmentStringToPathMatcher("swagger"))).apply((Function0 & Serializable)() -> (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.get()).apply((Function0 & Serializable)() -> Directives$.MODULE$.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)MODULE$.swaggerRedirectHttpResponse(internalConfig), Marshaller$.MODULE$.fromResponse()))))));
        }
        return RouteDirectives$.MODULE$.reject();
    }

    private Option<String> basicAuthOpt(Credentials credentials, BaklavaRoutes.Config internalConfig) {
        Tuple2 tuple2 = new Tuple2(internalConfig.basicAuthUser(), internalConfig.basicAuthPassword());
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                String user = (String)some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    String password = (String)some2.value();
                    Credentials credentials2 = credentials;
                    if (credentials2 instanceof Credentials.Provided) {
                        String id;
                        Credentials.Provided provided = (Credentials.Provided)credentials2;
                        String string = id = provided.identifier();
                        String string2 = user;
                        if (!(string != null ? !string.equals(string2) : string2 != null) && provided.verify(password)) {
                            return new Some((Object)id);
                        }
                    }
                    return None$.MODULE$;
                }
            }
        }
        return new Some((Object)"");
    }

    private String openApiFileContent(BaklavaRoutes.Config internalConfig) {
        BufferedSource source = Source$.MODULE$.fromFile(new StringBuilder(20).append(internalConfig.fileSystemPath()).append("/openapi/openapi.yml").toString(), Codec$.MODULE$.fallbackSystemCodec());
        OpenAPIV3Parser parser = new OpenAPIV3Parser();
        OpenAPI openApi = parser.readContents(source.mkString(), null, null).getOpenAPI();
        Server server = new Server();
        server.setUrl(internalConfig.apiPublicPathPrefix());
        openApi.setServers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)server, (List)Nil$.MODULE$)).asJava());
        return Yaml.pretty((Object)openApi);
    }

    private String swaggerInitializerContent(BaklavaRoutes.Config internalConfig) {
        String swaggerDocsUrl = new StringBuilder(7).append(internalConfig.publicPathPrefix()).append("openapi").toString();
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(441).append("\n       |window.onload = function() {\n       |  window.ui = SwaggerUIBundle({\n       |    url: \"").append(swaggerDocsUrl).append("\",\n       |    dom_id: '#swagger-ui',\n       |    deepLinking: true,\n       |    presets: [\n       |      SwaggerUIBundle.presets.apis,\n       |      SwaggerUIStandalonePreset\n       |    ],\n       |    plugins: [\n       |      SwaggerUIBundle.plugins.DownloadUrl\n       |    ],\n       |    layout: \"BaseLayout\"\n       |  });\n       |};\n       |").toString()));
    }

    private HttpResponse swaggerRedirectHttpResponse(BaklavaRoutes.Config internalConfig) {
        String swaggerUiUrl = new StringBuilder(22).append(internalConfig.publicPathPrefix()).append("swagger-ui/").append(this.swaggerVersion()).append("/index.html").toString();
        Location location = new Location(Uri$.MODULE$.apply(swaggerUiUrl));
        return HttpResponse$.MODULE$.apply((StatusCode)StatusCodes$.MODULE$.SeeOther(), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)location), HttpResponse$.MODULE$.apply$default$3(), HttpResponse$.MODULE$.apply$default$4());
    }

    private Function1<RequestContext, Future<RouteResult>> swaggerWebJar$lzycompute() {
        BaklavaRoutes$ baklavaRoutes$ = this;
        synchronized (baklavaRoutes$) {
            if (!bitmap$0) {
                swaggerWebJar = (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.extractUnmatchedPath(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)path -> {
                    boolean bl = false;
                    Failure failure = null;
                    Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> new WebJarAssetLocator().getFullPath("swagger-ui", path.toString()));
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        String fullPath = (String)success.value();
                        return Directives$.MODULE$.getFromResource(fullPath, ContentTypeResolver$.MODULE$.Default());
                    }
                    if (try_ instanceof Failure) {
                        bl = true;
                        failure = (Failure)try_;
                        if (failure.exception() instanceof IllegalArgumentException) {
                            return Directives$.MODULE$.reject();
                        }
                    }
                    if (bl) {
                        Throwable e = failure.exception();
                        return Directives$.MODULE$.failWith(e);
                    }
                    throw new MatchError((Object)try_);
                });
                bitmap$0 = true;
            }
        }
        return swaggerWebJar;
    }

    private Function1<RequestContext, Future<RouteResult>> swaggerWebJar() {
        if (!bitmap$0) {
            return this.swaggerWebJar$lzycompute();
        }
        return swaggerWebJar;
    }

    private BaklavaRoutes$() {
    }
}

