/*
 * Decompiled with CFR 0.152.
 */
package pl.iterators.baklava.formatter.openapi;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.io.Serializable;
import pl.iterators.baklava.core.model.EnrichedRouteRepresentation;
import pl.iterators.baklava.core.model.RouteDtoHandler;
import pl.iterators.baklava.core.model.RouteErrorResponse;
import pl.iterators.baklava.core.model.RouteHeaderRepresentation;
import pl.iterators.baklava.core.model.RouteParameterRepresentation;
import pl.iterators.baklava.core.model.RouteSecurity;
import pl.iterators.baklava.formatter.openapi.JsonSchemaToSwaggerSchemaWorker;
import pl.iterators.baklava.formatter.openapi.builders.OpenApiBuilder$;
import pl.iterators.baklava.formatter.openapi.builders.OperationBuilder$;
import pl.iterators.baklava.formatter.openapi.builders.PathItemBuilder$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\t\u0005g\u0001B\u000b\u0017\u0001\u0005B\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\u0006[\u0001!\tA\f\u0005\u0006c\u0001!\tA\r\u0005\u0006M\u0002!Ia\u001a\u0005\u0006k\u0002!IA\u001e\u0005\b\u0003_\u0001A\u0011BA\u0019\u0011\u001d\ti\u0005\u0001C\u0005\u0003\u001fBq!!\u001d\u0001\t\u0013\t\u0019\bC\u0004\u0002\u001c\u0002!I!!(\t\u000f\u0005E\u0006\u0001\"\u0003\u00024\"9\u0011Q\u0019\u0001\u0005\n\u0005\u001d\u0007bBAn\u0001\u0011%\u0011Q\u001c\u0005\b\u0003S\u0004A\u0011BAv\u0011\u001d\u00119\u0001\u0001C\u0005\u0005\u0013AqA!\u000b\u0001\t\u0013\u0011Y\u0003C\u0004\u0003N\u0001!IAa\u0014\t\u000f\t5\u0004\u0001\"\u0003\u0003p!9!\u0011\u0012\u0001\u0005\n\t-\u0005b\u0002BZ\u0001\u0011%!Q\u0017\u0005\b\u0005w\u0003A\u0011\u0002B_\u0005Yy\u0005/\u001a8Ba&4uN]7biR,'oV8sW\u0016\u0014(BA\f\u0019\u0003\u001dy\u0007/\u001a8ba&T!!\u0007\u000e\u0002\u0013\u0019|'/\\1ui\u0016\u0014(BA\u000e\u001d\u0003\u001d\u0011\u0017m\u001b7bm\u0006T!!\b\u0010\u0002\u0013%$XM]1u_J\u001c(\"A\u0010\u0002\u0005Ad7\u0001A\n\u0003\u0001\t\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012a!\u00118z%\u00164\u0017a\b6t_:\u001c6\r[3nCR{7k^1hO\u0016\u00148k\u00195f[\u0006<vN]6feB\u0011!fK\u0007\u0002-%\u0011AF\u0006\u0002 \u0015N|gnU2iK6\fGk\\*xC\u001e<WM]*dQ\u0016l\u0017mV8sW\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u00020aA\u0011!\u0006\u0001\u0005\u0006Q\t\u0001\r!K\u0001\u0010O\u0016tWM]1uK>\u0003XM\\!qSR\u00111'\u0011\t\u0003i}j\u0011!\u000e\u0006\u0003m]\na!\\8eK2\u001c(B\u0001\u001d:\u0003\ry\u0017m\u001d\u0006\u0003um\n!A^\u001a\u000b\u0005qj\u0014aB:xC\u001e<WM\u001d\u0006\u0002}\u0005\u0011\u0011n\\\u0005\u0003\u0001V\u0012qa\u00149f]\u0006\u0003\u0016\nC\u0003C\u0007\u0001\u00071)\u0001\u0006s_V$Xm\u001d'jgR\u00042\u0001\u0012'P\u001d\t)%J\u0004\u0002G\u00136\tqI\u0003\u0002IA\u00051AH]8pizJ\u0011!J\u0005\u0003\u0017\u0012\nq\u0001]1dW\u0006<W-\u0003\u0002N\u001d\n!A*[:u\u0015\tYE\u0005M\u0002Q5\u0012\u0004B!\u0015,YG6\t!K\u0003\u0002T)\u0006)Qn\u001c3fY*\u0011QKG\u0001\u0005G>\u0014X-\u0003\u0002X%\nYRI\u001c:jG\",GMU8vi\u0016\u0014V\r\u001d:fg\u0016tG/\u0019;j_:\u0004\"!\u0017.\r\u0001\u0011I1,QA\u0001\u0002\u0003\u0015\t\u0001\u0018\u0002\u0004?\u0012\n\u0014CA/a!\t\u0019c,\u0003\u0002`I\t9aj\u001c;iS:<\u0007CA\u0012b\u0013\t\u0011GEA\u0002B]f\u0004\"!\u00173\u0005\u0013\u0015\f\u0015\u0011!A\u0001\u0006\u0003a&aA0%e\u0005)\"o\\;uK2K7\u000f\u001e+p\u0007>l\u0007o\u001c8f]R\u001cHC\u00015l!\t!\u0014.\u0003\u0002kk\tQ1i\\7q_:,g\u000e^:\t\u000b\t#\u0001\u0019\u00017\u0011\u0007\u0011cU\u000eM\u0002oaN\u0004B!\u0015,peB\u0011\u0011\f\u001d\u0003\nc.\f\t\u0011!A\u0003\u0002q\u00131a\u0018\u00134!\tI6\u000fB\u0005uW\u0006\u0005\t\u0011!B\u00019\n\u0019q\f\n\u001b\u0002+I|W\u000f^3U_N\u001b\u0007.Z7b/&$\bNT1nKR\u0019q/a\u0007\u0011\u0007\u0011c\u0005\u0010E\u0003$sn\f9!\u0003\u0002{I\t1A+\u001e9mKJ\u00022\u0001`A\u0001\u001d\tih\u0010\u0005\u0002GI%\u0011q\u0010J\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0011Q\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}$\u0003\u0007BA\u0005\u0003/\u0001b!a\u0003\u0002\u0012\u0005UQBAA\u0007\u0015\r\ty!N\u0001\u0006[\u0016$\u0017.Y\u0005\u0005\u0003'\tiA\u0001\u0004TG\",W.\u0019\t\u00043\u0006]AACA\r\u000b\u0005\u0005\t\u0011!B\u00019\n\u0019q\fJ\u001c\t\u000f\u0005uQ\u00011\u0001\u0002 \u0005)!o\\;uKB2\u0011\u0011EA\u0013\u0003W\u0001b!\u0015,\u0002$\u0005%\u0002cA-\u0002&\u0011Y\u0011qEA\u000e\u0003\u0003\u0005\tQ!\u0001]\u0005\ryF%\u000e\t\u00043\u0006-BaCA\u0017\u00037\t\t\u0011!A\u0003\u0002q\u00131a\u0018\u00137\u0003A\u0011x.\u001e;f\u0019&\u001cH\u000fV8QCRD7\u000f\u0006\u0003\u00024\u0005e\u0002c\u0001\u001b\u00026%\u0019\u0011qG\u001b\u0003\u000bA\u000bG\u000f[:\t\r\t3\u0001\u0019AA\u001e!\u0011!E*!\u00101\r\u0005}\u00121IA%!\u0019\tf+!\u0011\u0002HA\u0019\u0011,a\u0011\u0005\u0017\u0005\u0015\u0013\u0011HA\u0001\u0002\u0003\u0015\t\u0001\u0018\u0002\u0004?\u0012B\u0004cA-\u0002J\u0011Y\u00111JA\u001d\u0003\u0003\u0005\tQ!\u0001]\u0005\ryF%O\u0001\u001de>,H/Z$s_V\u0004X\r\u001a\"z!\u0006$\b\u000eV8QCRD\u0017\n^3n)\u0019\t\t&a\u0016\u0002\\A\u0019A'a\u0015\n\u0007\u0005USG\u0001\u0005QCRD\u0017\n^3n\u0011\u0019\tIf\u0002a\u0001w\u0006!\u0001/\u0019;i\u0011\u001d\tif\u0002a\u0001\u0003?\naA]8vi\u0016\u001c\b\u0003\u0002#M\u0003C\u0002d!a\u0019\u0002h\u00055\u0004CB)W\u0003K\nY\u0007E\u0002Z\u0003O\"1\"!\u001b\u0002\\\u0005\u0005\t\u0011!B\u00019\n!q\fJ\u00191!\rI\u0016Q\u000e\u0003\f\u0003_\nY&!A\u0001\u0002\u000b\u0005AL\u0001\u0003`IE\n\u0014!I3yiJ\f7\r^(qKJ\fG/[8o\rJ|Wn\u0012:pkB,GMQ=QCRDGCBA;\u0003\u0003\u000b9\nE\u0003$\u0003o\nY(C\u0002\u0002z\u0011\u0012aa\u00149uS>t\u0007c\u0001\u001b\u0002~%\u0019\u0011qP\u001b\u0003\u0013=\u0003XM]1uS>t\u0007bBAB\u0011\u0001\u0007\u0011QQ\u0001\bOJ|W\u000f]3e!\u0011!E*a\"1\r\u0005%\u0015QRAJ!\u0019\tf+a#\u0002\u0012B\u0019\u0011,!$\u0005\u0017\u0005=\u0015\u0011QA\u0001\u0002\u0003\u0015\t\u0001\u0018\u0002\u0005?\u0012\n$\u0007E\u0002Z\u0003'#1\"!&\u0002\u0002\u0006\u0005\t\u0011!B\u00019\n!q\fJ\u00194\u0011\u0019\tI\n\u0003a\u0001w\u0006Iq\u000e]3sCRLwN\\\u0001\u0011e>,H/\u001a+p\u001fB,'/\u0019;j_:$B!a\u001f\u0002 \"9\u0011QD\u0005A\u0002\u0005\u0005\u0006GBAR\u0003O\u000bi\u000b\u0005\u0004R-\u0006\u0015\u00161\u0016\t\u00043\u0006\u001dFaCAU\u0003?\u000b\t\u0011!A\u0003\u0002q\u0013Aa\u0018\u00132iA\u0019\u0011,!,\u0005\u0017\u0005=\u0016qTA\u0001\u0002\u0003\u0015\t\u0001\u0018\u0002\u0005?\u0012\nT'A\u000bfqR\u0014\u0018m\u0019;QCJ\fWn\u001d$s_6\u0004\u0016\r\u001e5\u0015\t\u0005U\u00161\u0019\t\u0005\t2\u000b9\f\u0005\u0003\u0002:\u0006}VBAA^\u0015\r\ti,N\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\u0018\u0002BAa\u0003w\u0013\u0011\u0002U1sC6,G/\u001a:\t\r\u0005e#\u00021\u0001|\u0003M\tX/\u001a:z!\u0006\u0014\u0018-\\:U_B\u000b'/Y7t)\u0011\t),!3\t\u000f\u0005u6\u00021\u0001\u0002LB!A\tTAga\u0011\ty-a6\u0011\u000bE\u000b\t.!6\n\u0007\u0005M'K\u0001\u000fS_V$X\rU1sC6,G/\u001a:SKB\u0014Xm]3oi\u0006$\u0018n\u001c8\u0011\u0007e\u000b9\u000eB\u0006\u0002Z\u0006%\u0017\u0011!A\u0001\u0006\u0003a&\u0001B0%cY\nq\u0002[3bI\u0016\u00148\u000fV8QCJ\fWn\u001d\u000b\u0005\u0003k\u000by\u000eC\u0004\u0002>2\u0001\r!!9\u0011\t\u0011c\u00151\u001d\t\u0004#\u0006\u0015\u0018bAAt%\nI\"k\\;uK\"+\u0017\rZ3s%\u0016\u0004(/Z:f]R\fG/[8o\u0003I\u0011x.\u001e;f)>\u0014V-];fgR\u0014u\u000eZ=\u0015\t\u00055\u0018Q\u001f\t\u0006G\u0005]\u0014q\u001e\t\u0005\u0003s\u000b\t0\u0003\u0003\u0002t\u0006m&a\u0003*fcV,7\u000f\u001e\"pIfDq!!\b\u000e\u0001\u0004\t9\u0010\r\u0004\u0002z\u0006u(1\u0001\t\u0007#Z\u000bYP!\u0001\u0011\u0007e\u000bi\u0010B\u0006\u0002\u0000\u0006U\u0018\u0011!A\u0001\u0006\u0003a&\u0001B0%ca\u00022!\u0017B\u0002\t-\u0011)!!>\u0002\u0002\u0003\u0005)\u0011\u0001/\u0003\t}#\u0013'O\u0001\u0014e>,H/\u001a+p\u0003BL'+Z:q_:\u001cXm\u001d\u000b\u0005\u0005\u0017\u00119\u0002\u0005\u0003\u0003\u000e\tMQB\u0001B\b\u0015\r\u0011\t\"N\u0001\ne\u0016\u001c\bo\u001c8tKNLAA!\u0006\u0003\u0010\ta\u0011\t]5SKN\u0004xN\\:fg\"9\u0011Q\u0004\bA\u0002\te\u0001G\u0002B\u000e\u0005?\u0011)\u0003\u0005\u0004R-\nu!1\u0005\t\u00043\n}Aa\u0003B\u0011\u0005/\t\t\u0011!A\u0003\u0002q\u0013Aa\u0018\u00133aA\u0019\u0011L!\n\u0005\u0017\t\u001d\"qCA\u0001\u0002\u0003\u0015\t\u0001\u0018\u0002\u0005?\u0012\u0012\u0014'A\bs_V$X\rV8TK\u000e,(/\u001b;z)\u0011\u0011iCa\u000f\u0011\t\u0011c%q\u0006\t\u0005\u0005c\u00119$\u0004\u0002\u00034)\u0019!QG\u001b\u0002\u0011M,7-\u001e:jifLAA!\u000f\u00034\t\u00192+Z2ve&$\u0018PU3rk&\u0014X-\\3oi\"9\u0011QD\bA\u0002\tu\u0002G\u0002B \u0005\u0007\u0012I\u0005\u0005\u0004R-\n\u0005#q\t\t\u00043\n\rCa\u0003B#\u0005w\t\t\u0011!A\u0003\u0002q\u0013Aa\u0018\u00133eA\u0019\u0011L!\u0013\u0005\u0017\t-#1HA\u0001\u0002\u0003\u0015\t\u0001\u0018\u0002\u0005?\u0012\u00124'\u0001\u0016s_V$XmU3dkJLG/_$s_V\u0004Hk\\*fGV\u0014\u0018\u000e^=TG\",W.Y,ji\"t\u0015-\\3\u0015\t\tE#1\f\t\u0005\t2\u0013\u0019\u0006E\u0003$sn\u0014)\u0006\u0005\u0003\u00032\t]\u0013\u0002\u0002B-\u0005g\u0011abU3dkJLG/_*dQ\u0016lW\rC\u0004\u0002\u001eA\u0001\rA!\u00181\r\t}#1\rB5!\u0019\tfK!\u0019\u0003hA\u0019\u0011La\u0019\u0005\u0017\t\u0015$1LA\u0001\u0002\u0003\u0015\t\u0001\u0018\u0002\u0005?\u0012\u0012D\u0007E\u0002Z\u0005S\"1Ba\u001b\u0003\\\u0005\u0005\t\u0011!B\u00019\n!q\f\n\u001a6\u0003i\u0011x.\u001e;f\tR|\u0007*\u00198eY\u0016\u0014Hk\\'fI&\fG+\u001f9f)\u0011\u0011\tHa\u001e\u0011\t\u0005-!1O\u0005\u0005\u0005k\niAA\u0005NK\u0012L\u0017\rV=qK\"9!\u0011P\tA\u0002\tm\u0014a\u00013u_B\"!Q\u0010BC!\u0015\t&q\u0010BB\u0013\r\u0011\tI\u0015\u0002\u0010%>,H/\u001a#u_\"\u000bg\u000e\u001a7feB\u0019\u0011L!\"\u0005\u0017\t\u001d%qOA\u0001\u0002\u0003\u0015\t\u0001\u0018\u0002\u0005?\u0012\u0012d'A\u0007to\u0006<w-\u001a:TG\",W.Y\u000b\u0005\u0005\u001b\u0013y\u000b\u0006\u0003\u0003\u0010\ne\u0005\u0007\u0002BI\u0005+\u0003b!a\u0003\u0002\u0012\tM\u0005cA-\u0003\u0016\u0012Q!q\u0013\n\u0002\u0002\u0003\u0005)\u0011\u0001/\u0003\t}##g\u000e\u0005\b\u00057\u0013\u0002\u0019\u0001BO\u0003)Q7o\u001c8TG\",W.\u0019\t\u0007\u0005?\u0013IK!,\u000e\u0005\t\u0005&\u0002\u0002BR\u0005K\u000b!B[:p]N\u001c\u0007.Z7b\u0015\r\u00119\u000bH\u0001\u0005W\u0016\u00147/\u0003\u0003\u0003,\n\u0005&!\u0005&t_:\u001c6\r[3nC^\u0013\u0018\r\u001d9feB\u0019\u0011La,\u0005\r\tE&C1\u0001]\u0005\u0005!\u0016!D:dQ\u0016l\u0017MU3g\u001d\u0006lW\rF\u0002|\u0005oCaA!/\u0014\u0001\u0004Y\u0018\u0001\u00028b[\u0016\fqb]2iK6\f7\t\\1tg:\u000bW.\u001a\u000b\u0004w\n}\u0006B\u0002B])\u0001\u00071\u0010")
public class OpenApiFormatterWorker {
    private final JsonSchemaToSwaggerSchemaWorker jsonSchemaToSwaggerSchemaWorker;

    public OpenAPI generateOpenApi(List<EnrichedRouteRepresentation<?, ?>> routesList) {
        return OpenApiBuilder$.MODULE$.build(new Info().title("Autogenerated API doc").version("1"), this.routeListToComponents(routesList), this.routeListToPaths(routesList));
    }

    private Components routeListToComponents(List<EnrichedRouteRepresentation<?, ?>> routesList) {
        Components components = new Components();
        routesList.flatMap((Function1 & Serializable)route -> this.routeToSchemaWithName((EnrichedRouteRepresentation<?, ?>)route)).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Schema schema = (Schema)tuple2._2();
                return components.addSchemas(name, schema);
            }
            throw new MatchError((Object)tuple2);
        });
        routesList.flatMap((Function1 & Serializable)route -> this.routeSecurityGroupToSecuritySchemaWithName((EnrichedRouteRepresentation<?, ?>)route)).foreach((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                SecurityScheme schema = (SecurityScheme)tuple2._2();
                return components.addSecuritySchemes(name, schema);
            }
            throw new MatchError((Object)tuple2);
        });
        return components;
    }

    private List<Tuple2<String, Schema<?>>> routeToSchemaWithName(EnrichedRouteRepresentation<?, ?> route) {
        return new .colon.colon((Object)route.routeRepresentation().request(), (List)new .colon.colon((Object)route.routeRepresentation().response(), (List)Nil$.MODULE$)).flatMap((Function1 & Serializable)dto -> dto.scalaClassOpt().map((Function1 & Serializable)scalaClassName -> new Tuple2((Object)this.schemaClassName((String)scalaClassName), this.swaggerSchema(dto.jsonSchemaWrapper()))));
    }

    private Paths routeListToPaths(List<EnrichedRouteRepresentation<?, ?>> routesList) {
        Paths paths = new Paths();
        ((List)routesList.groupBy((Function1 & Serializable)x$1 -> x$1.routeRepresentation().path()).toList().sortBy((Function1 & Serializable)x$2 -> (String)x$2._1(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String path = (String)tuple2._1();
                List routes = (List)tuple2._2();
                return paths.addPathItem(path, this.routeGroupedByPathToPathItem(path, routes));
            }
            throw new MatchError((Object)tuple2);
        });
        return paths;
    }

    private PathItem routeGroupedByPathToPathItem(String path, List<EnrichedRouteRepresentation<?, ?>> routes) {
        return PathItemBuilder$.MODULE$.build(this.extractParamsFromPath(path), this.extractOperationFromGroupedByPath(routes, "GET"), this.extractOperationFromGroupedByPath(routes, "POST"), this.extractOperationFromGroupedByPath(routes, "PATCH"), this.extractOperationFromGroupedByPath(routes, "PUT"), this.extractOperationFromGroupedByPath(routes, "DELETE"));
    }

    private Option<Operation> extractOperationFromGroupedByPath(List<EnrichedRouteRepresentation<?, ?>> grouped, String operation) {
        return grouped.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)OpenApiFormatterWorker.$anonfun$extractOperationFromGroupedByPath$1(operation, x$3))).map((Function1 & Serializable)route -> this.routeToOperation((EnrichedRouteRepresentation<?, ?>)route));
    }

    private Operation routeToOperation(EnrichedRouteRepresentation<?, ?> route) {
        return OperationBuilder$.MODULE$.build(route.routeRepresentation().description(), (String)route.routeRepresentation().extendedDescription().getOrElse((Function0 & Serializable)() -> ((IterableOnceOps)route.enrichDescriptions().map((Function1 & Serializable)x$4 -> x$4.description())).mkString("\n")), (List<Parameter>)((List)this.queryParamsToParams(route.routeRepresentation().parameters()).$plus$plus(this.headersToParams((List<RouteHeaderRepresentation>)route.routeRepresentation().headers()))), this.routeToRequestBody(route), this.routeToApiResponses(route), this.routeToSecurity(route));
    }

    private List<Parameter> extractParamsFromPath(String path) {
        Regex pattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\{(.*?)\\}"));
        return pattern.findAllMatchIn((CharSequence)path).toList().map((Function1 & Serializable)m -> {
            Parameter p = new Parameter();
            p.setName(m.group(1));
            p.setIn("path");
            p.setSchema((Schema)new StringSchema());
            return p;
        });
    }

    private List<Parameter> queryParamsToParams(List<RouteParameterRepresentation<?>> parameters) {
        return parameters.map((Function1 & Serializable)param -> {
            StringSchema stringSchema;
            StringSchema itemSchema = new StringSchema();
            itemSchema.setExample(param.valueGenerator().apply());
            param.enums().foreach((Function1 & Serializable)values -> {
                itemSchema.setEnum(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)values.toList()).asJava());
                return BoxedUnit.UNIT;
            });
            if (param.seq()) {
                ArraySchema arraySchema = new ArraySchema();
                arraySchema.setItems((Schema)itemSchema);
                stringSchema = arraySchema;
            } else {
                stringSchema = itemSchema;
            }
            StringSchema schema = stringSchema;
            Parameter p = new Parameter();
            if (param.seq()) {
                p.setName(new StringBuilder(2).append(param.name()).append("[]").toString());
            } else {
                p.setName(param.name());
            }
            p.setIn("query");
            p.setRequired(Predef$.MODULE$.boolean2Boolean(param.required()));
            p.setSchema((Schema)schema);
            return p;
        });
    }

    private List<Parameter> headersToParams(List<RouteHeaderRepresentation> parameters) {
        return parameters.map((Function1 & Serializable)header -> {
            Parameter p = new Parameter();
            p.setName(header.name());
            p.setIn("header");
            p.setRequired(Predef$.MODULE$.boolean2Boolean(header.required()));
            p.setSchema((Schema)new StringSchema());
            return p;
        });
    }

    private Option<RequestBody> routeToRequestBody(EnrichedRouteRepresentation<?, ?> route) {
        return route.routeRepresentation().request().minimal().jsonString().map((Function1 & Serializable)x$5 -> {
            MediaType mt = this.routeDtoHandlerToMediaType(route.routeRepresentation().request());
            RequestBody apiRequest = new RequestBody();
            apiRequest.setRequired(Predef$.MODULE$.boolean2Boolean(true));
            apiRequest.setContent(new Content().addMediaType("application/json", mt));
            return apiRequest;
        });
    }

    private ApiResponses routeToApiResponses(EnrichedRouteRepresentation<?, ?> route) {
        ApiResponses apiResponses = new ApiResponses();
        ((List)((IterableOnceOps)route.enrichDescriptions().groupBy((Function1 & Serializable)x$6 -> x$6.statusCodeOpt()).filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)OpenApiFormatterWorker.$anonfun$routeToApiResponses$2(x$7)))).toList().sortBy((Function1 & Serializable)x$8 -> ((Option)x$8._1()).map((Function1)(JFunction1.mcII.sp & Serializable)x$9 -> x$9), Ordering$.MODULE$.Option((Ordering)Ordering.Int$.MODULE$))).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option codeOpt = (Option)tuple2._1();
                scala.collection.immutable.Seq desc = (scala.collection.immutable.Seq)tuple2._2();
                int code = BoxesRunTime.unboxToInt((Object)codeOpt.get());
                ApiResponse apiResponse = new ApiResponse();
                apiResponse.setDescription(((IterableOnceOps)desc.map((Function1 & Serializable)x$10 -> x$10.description())).mkString("\n"));
                if (code >= 200 && code < 204) {
                    MediaType mt = this.routeDtoHandlerToMediaType(route.routeRepresentation().response());
                    apiResponse.setContent(new Content().addMediaType("application/json", mt));
                } else {
                    MediaType mt = new MediaType();
                    route.routeRepresentation().errorResponses().filter((Function1 & Serializable)er -> BoxesRunTime.boxToBoolean((boolean)OpenApiFormatterWorker.$anonfun$routeToApiResponses$7(code, er))).foreach((Function1 & Serializable)errorResponse -> {
                        Example example = new Example();
                        example.setValue((Object)new StringBuilder(24).append("{\"type\": \"").append(errorResponse.jsonData().type()).append("\", \"status\": ").append(errorResponse.status()).append("}").toString());
                        return mt.addExamples(errorResponse.resultName(), example);
                    });
                    if (Option$.MODULE$.apply((Object)mt.getExamples()).nonEmpty()) {
                        apiResponse.setContent(new Content().addMediaType("application/json", mt));
                    }
                }
                return apiResponses.addApiResponse(Integer.toString(code), apiResponse);
            }
            throw new MatchError((Object)tuple2);
        });
        return apiResponses;
    }

    private List<SecurityRequirement> routeToSecurity(EnrichedRouteRepresentation<?, ?> route) {
        return route.routeRepresentation().authentication().map((Function1 & Serializable)routeSecurityGroup -> {
            SecurityRequirement security = new SecurityRequirement();
            routeSecurityGroup.list().map((Function1 & Serializable)x$11 -> x$11.schemaName()).foreach((Function1 & Serializable)x$1 -> security.addList(x$1));
            return security;
        });
    }

    private List<Tuple2<String, SecurityScheme>> routeSecurityGroupToSecuritySchemaWithName(EnrichedRouteRepresentation<?, ?> route) {
        return ((List)route.routeRepresentation().authentication().flatMap((Function1 & Serializable)x$12 -> x$12.list()).distinct()).map((Function1 & Serializable)x0$1 -> {
            RouteSecurity routeSecurity = x0$1;
            if (routeSecurity instanceof RouteSecurity.Bearer) {
                RouteSecurity.Bearer bearer = (RouteSecurity.Bearer)routeSecurity;
                String schemaName = bearer.schemaName();
                SecurityScheme securityScheme = new SecurityScheme();
                securityScheme.setScheme("bearer");
                securityScheme.setBearerFormat("JWT");
                securityScheme.setType(SecurityScheme.Type.HTTP);
                return new Tuple2((Object)schemaName, (Object)securityScheme);
            }
            if (routeSecurity instanceof RouteSecurity.Basic) {
                RouteSecurity.Basic basic = (RouteSecurity.Basic)routeSecurity;
                String schemaName = basic.schemaName();
                SecurityScheme securityScheme = new SecurityScheme();
                securityScheme.setScheme("basic");
                securityScheme.setType(SecurityScheme.Type.HTTP);
                return new Tuple2((Object)schemaName, (Object)securityScheme);
            }
            if (routeSecurity instanceof RouteSecurity.HeaderApiKey) {
                RouteSecurity.HeaderApiKey headerApiKey = (RouteSecurity.HeaderApiKey)routeSecurity;
                String name = headerApiKey.name();
                String schemaName = headerApiKey.schemaName();
                SecurityScheme securityScheme = new SecurityScheme();
                securityScheme.setType(SecurityScheme.Type.APIKEY);
                securityScheme.setIn(SecurityScheme.In.HEADER);
                securityScheme.setName(name);
                return new Tuple2((Object)schemaName, (Object)securityScheme);
            }
            if (routeSecurity instanceof RouteSecurity.QueryApiKey) {
                RouteSecurity.QueryApiKey queryApiKey = (RouteSecurity.QueryApiKey)routeSecurity;
                String name = queryApiKey.name();
                String schemaName = queryApiKey.schemaName();
                SecurityScheme securityScheme = new SecurityScheme();
                securityScheme.setType(SecurityScheme.Type.APIKEY);
                securityScheme.setIn(SecurityScheme.In.QUERY);
                securityScheme.setName(name);
                return new Tuple2((Object)schemaName, (Object)securityScheme);
            }
            if (routeSecurity instanceof RouteSecurity.CookieApiKey) {
                RouteSecurity.CookieApiKey cookieApiKey = (RouteSecurity.CookieApiKey)routeSecurity;
                String name = cookieApiKey.name();
                String schemaName = cookieApiKey.schemaName();
                SecurityScheme securityScheme = new SecurityScheme();
                securityScheme.setType(SecurityScheme.Type.APIKEY);
                securityScheme.setIn(SecurityScheme.In.COOKIE);
                securityScheme.setName(name);
                return new Tuple2((Object)schemaName, (Object)securityScheme);
            }
            throw new MatchError((Object)routeSecurity);
        });
    }

    private MediaType routeDtoHandlerToMediaType(RouteDtoHandler<?> dto) {
        MediaType mt = new MediaType();
        dto.minimal().jsonString().foreach((Function1 & Serializable)json -> {
            OpenApiFormatterWorker.$anonfun$routeDtoHandlerToMediaType$1(this, mt, dto, json);
            return BoxedUnit.UNIT;
        });
        dto.maximal().jsonString().foreach((Function1 & Serializable)json -> {
            Example example = new Example();
            example.setValue(json);
            return mt.addExamples("maximal", example);
        });
        return mt;
    }

    private <T> Schema<?> swaggerSchema(json.Schema<T> jsonSchema) {
        return this.jsonSchemaToSwaggerSchemaWorker.convertMatch(jsonSchema);
    }

    private String schemaRefName(String name) {
        return new StringBuilder(21).append("#/components/schemas/").append(this.schemaClassName(name)).toString();
    }

    private String schemaClassName(String name) {
        return name.replaceAll("\\[", "_").replaceAll("\\]", "");
    }

    public static final /* synthetic */ boolean $anonfun$extractOperationFromGroupedByPath$1(String operation$1, EnrichedRouteRepresentation x$3) {
        String string2 = x$3.routeRepresentation().method().toUpperCase();
        String string3 = operation$1.toUpperCase();
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$routeToApiResponses$2(Tuple2 x$7) {
        return ((Option)x$7._1()).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$routeToApiResponses$7(int code$1, RouteErrorResponse er) {
        return er.status() == code$1;
    }

    public static final /* synthetic */ void $anonfun$routeDtoHandlerToMediaType$1(OpenApiFormatterWorker $this, MediaType mt$2, RouteDtoHandler dto$2, String json) {
        Example example = new Example();
        example.setValue((Object)json);
        mt$2.addExamples("minimal", example);
        Schema schema = new Schema();
        schema.setType($this.swaggerSchema(dto$2.jsonSchemaWrapper()).getType());
        schema.set$ref($this.schemaRefName((String)dto$2.scalaClassOpt().get()));
        mt$2.setSchema(schema);
    }

    public OpenApiFormatterWorker(JsonSchemaToSwaggerSchemaWorker jsonSchemaToSwaggerSchemaWorker) {
        this.jsonSchemaToSwaggerSchemaWorker = jsonSchemaToSwaggerSchemaWorker;
    }
}

