/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.service.embedded.keycloak;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.core.Dispatcher;
import org.keycloak.exportimport.Strategy;
import org.keycloak.exportimport.singlefile.SingleFileImportProvider;
import org.keycloak.exportimport.util.ImportUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.util.JsonSerialization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedKeycloakApplication
extends KeycloakApplication {
    public static final String SERVER_CONTEXT_PATH = "keycloak.embedded.server.context-path";
    public static final String REALM_CONFIGURATION_PATH = "keycloak.embedded.realm.configuration.path";
    public static final String REALM_CONFIGURATION_STRATEGY = "keycloak.embedded.realm.configuration.strategy";
    public static final String ADMIN_USERNAME = "keycloak.embedded.security.admin.username";
    public static final String ADMIN_PASSWORD = "keycloak.embedded.security.admin.password";
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedKeycloakApplication.class);
    private String adminUser;
    private String adminPassword;
    private String realmConfigPath;
    private String realmConfigStrategy;

    public EmbeddedKeycloakApplication(@Context ServletContext context, @Context Dispatcher dispatcher) {
        super(EmbeddedKeycloakApplication.augmentToRedirectContextPath(context), dispatcher);
        this.realmConfigPath = context.getInitParameter(REALM_CONFIGURATION_PATH);
        this.realmConfigStrategy = context.getInitParameter(REALM_CONFIGURATION_STRATEGY);
        this.adminUser = context.getInitParameter(ADMIN_USERNAME);
        this.adminPassword = context.getInitParameter(ADMIN_PASSWORD);
        this.createAdminUser();
        this.loadKeycloakRealmConfiguration(this.realmConfigPath);
    }

    protected Strategy resolveRealmConfigurationStrategy(String strategyName) {
        try {
            Strategy strategy = Strategy.valueOf((String)strategyName);
            return strategy;
        }
        catch (Exception e) {
            LOG.warn("Unable to resolve realm configuration strategy: {}, applying default strategy: {}", (Object)strategyName, (Object)Strategy.OVERWRITE_EXISTING.name());
            return Strategy.OVERWRITE_EXISTING;
        }
    }

    protected void loadKeycloakRealmConfiguration(String path) {
        try {
            LOG.info("Loading keycloak realm configuration from resource: {}", (Object)path);
            final InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(path);
            if (stream == null) {
                LOG.error("Unable to find keycloak realm  in file: {}", (Object)path);
                return;
            }
            SingleFileImportProvider importProvider = new SingleFileImportProvider(new File(path)){

                protected void checkRealmReps() throws IOException {
                    this.realmReps = ImportUtils.getRealmsFromStream((ObjectMapper)JsonSerialization.mapper, (InputStream)stream);
                }
            };
            importProvider.importModel(this.sessionFactory, this.resolveRealmConfigurationStrategy(this.realmConfigStrategy));
            LOG.error("Keycloak realm configuration loaded successfully");
        }
        catch (Exception e) {
            LOG.error("Unable to load keycloak realm configuration", (Throwable)e);
        }
    }

    protected void createAdminUser() {
        KeycloakSession session = this.getSessionFactory().create();
        ApplianceBootstrap applianceBootstrap = new ApplianceBootstrap(session);
        try {
            session.getTransactionManager().begin();
            applianceBootstrap.createMasterRealmUser(this.adminUser, this.adminPassword);
            session.getTransactionManager().commit();
        }
        catch (Exception e) {
            LOG.warn("Couldn't create keycloak master admin user: {}", (Object)e.getMessage());
            session.getTransactionManager().rollback();
        }
        session.close();
    }

    private static ServletContext augmentToRedirectContextPath(ServletContext context) {
        ClassLoader classLoader = context.getClassLoader();
        Class[] interfaces = new Class[]{ServletContext.class};
        InvocationHandler invocationHandler = (proxy, method, args) -> {
            if ("getContextPath".equals(method.getName())) {
                String kcContextPath = context.getInitParameter(SERVER_CONTEXT_PATH);
                String appContextPath = context.getContextPath();
                return appContextPath + kcContextPath;
            }
            LOG.info("Invoke on ServletContext: method=[{}] args=[{}]", (Object)method.getName(), (Object)Arrays.toString(args));
            return method.invoke((Object)context, args);
        };
        return (ServletContext)ServletContext.class.cast(Proxy.newProxyInstance(classLoader, interfaces, invocationHandler));
    }
}

