/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import pl.grizzlysoftware.util.JacksonProvider;
import pl.grizzlysoftware.util.LoggingJacksonResponseBodyConverter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public final class RetrofitUtils {
    public static Retrofit retrofit(OkHttpClient client, String url) {
        if (url != null && !((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        final ObjectMapper mapper = JacksonProvider.mapper;
        return new Retrofit.Builder().baseUrl((String)url).client(client).addConverterFactory(new Converter.Factory(){
            Converter.Factory jks;
            {
                this.jks = JacksonConverterFactory.create((ObjectMapper)mapper);
            }

            public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
                return this.jks.requestBodyConverter(type, parameterAnnotations, methodAnnotations, retrofit);
            }

            public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
                return new LoggingJacksonResponseBodyConverter(mapper, type);
            }
        }).build();
    }

    public static <T> T service(OkHttpClient client, String host, Class<T> clazz) {
        return (T)RetrofitUtils.retrofit(client, host).create(clazz);
    }
}

