/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.util;

import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.grizzlysoftware.dotykacka.util.exception.ExceptionPreconditions;
import pl.grizzlysoftware.util.OnRetrofitCallExecutionListener;
import pl.grizzlysoftware.util.ResponseStatusException;
import retrofit2.Call;
import retrofit2.Response;

public class RetrofitCallExecutor
implements OnRetrofitCallExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetrofitCallExecutor.class);
    private static final String EXCEPTIONAL_MESSAGE_PATTERN = "Unable to invoke external service: '%s'request url: '%s'%nrequest method: '%s'%nrequest headers: '%s'%nrequest body: %n'%s'%nresponse status: '%s'%nresponse message: '%s'%nresponse headers: %n'%s'%nresponse body: %n'%s'";
    protected final Class<?> target;
    protected OnRetrofitCallExecutionListener callExecutionListener = this;

    public RetrofitCallExecutor(Class<?> target) {
        this.target = Objects.requireNonNull(target);
    }

    public <T> T execOrThrow(Call<T> call) {
        return (T)this.executeOrThrow(call).body();
    }

    public <T> Response<T> executeOrThrow(Call<T> call) {
        try {
            this.callExecutionListener.onBeforeExecution(call);
            Response response = Objects.requireNonNull(call).execute();
            this.callExecutionListener.onAfterExecution(call, response);
            if (!response.isSuccessful()) {
                Request request = call.request();
                throw new ResponseStatusException(response.code(), String.format(EXCEPTIONAL_MESSAGE_PATTERN, this.target.getSimpleName(), request.url().url().toString(), request.method(), request.headers().toString(), this.requestBodyAsString(request), response.code(), response.message(), response.headers().toString(), Optional.ofNullable(response.errorBody()).map(this::unwrapBody).orElse("{}")));
            }
            this.callExecutionListener.onExecutionSuccessful(call, response);
            return response;
        }
        catch (JsonMappingException e) {
            LOGGER.error("Exception occured while deserializing response: {}", (Object)e.getMessage());
            throw new ResponseStatusException(500);
        }
        catch (IOException e) {
            LOGGER.error("Exception occured while sending request: {}", (Object)e.getMessage());
            throw new ResponseStatusException(503);
        }
    }

    public void setCallExecutionListener(OnRetrofitCallExecutionListener callExecutionListener) {
        this.callExecutionListener = ExceptionPreconditions.checkNotNull(callExecutionListener, "20211118:213525", "OnRetrofitCallExecutionListener cannot be null");
    }

    private String requestBodyAsString(Request request) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Buffer sink = new Buffer();
        RequestBody body = request.body();
        if (body == null) {
            return "{}";
        }
        body.writeTo((BufferedSink)sink);
        sink.copyTo((OutputStream)baos);
        return baos.toString(StandardCharsets.UTF_8);
    }

    private String unwrapBody(ResponseBody body) {
        try {
            return body.string();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> void onBeforeExecution(Call<T> call) {
    }

    @Override
    public <T> void onAfterExecution(Call<T> call, Response<T> response) {
    }

    @Override
    public <T> void onExecutionSuccessful(Call<T> call, Response<T> response) {
    }
}

