/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.util;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpLoggingInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(OkHttpLoggingInterceptor.class);

    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        long t1 = System.nanoTime();
        logger.debug("Sending request [{}] {} \n*HEADERS:\n{}", new Object[]{request.method(), request.url(), request.headers()});
        Response response = chain.proceed(request);
        long t2 = System.nanoTime();
        logger.debug("Received response for [{}] {} \n*TIME ELAPSED:{}\n*STATUS: {}\n*HEADERS:\n{}", new Object[]{request.method(), response.request().url(), (double)(t2 - t1) / 1000000.0, response.code(), response.headers()});
        return response;
    }
}

