/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.util;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.grizzlysoftware.dotykacka.util.exception.ExceptionPreconditions;
import pl.grizzlysoftware.util.OnRetrofitCallExecutionListener;
import retrofit2.Call;
import retrofit2.Response;

public class CompositeOnRetroCallExecutionListener
implements OnRetrofitCallExecutionListener {
    private static final Logger logger = LoggerFactory.getLogger(CompositeOnRetroCallExecutionListener.class);
    protected final Collection<OnRetrofitCallExecutionListener> listeners;

    public CompositeOnRetroCallExecutionListener(Collection<OnRetrofitCallExecutionListener> listeners) {
        this.listeners = ExceptionPreconditions.checkNotNull(listeners, "20211118:215816", "Collection<OnRetrofitCallExecutionListener> cannot be null");
    }

    @Override
    public <T> void onBeforeExecution(Call<T> call) {
        this.listeners.forEach(e -> this.invokeOnBeforeExecution((OnRetrofitCallExecutionListener)e, call));
    }

    @Override
    public <T> void onAfterExecution(Call<T> call, Response<T> response) {
        this.listeners.forEach(e -> this.invokeOnAfterExecution((OnRetrofitCallExecutionListener)e, call, response));
    }

    @Override
    public <T> void onExecutionSuccessful(Call<T> call, Response<T> response) {
        this.listeners.forEach(e -> this.invokeOnExecutionSuccessful((OnRetrofitCallExecutionListener)e, call, response));
    }

    protected <T> void invokeOnBeforeExecution(OnRetrofitCallExecutionListener listener, Call<T> call) {
        try {
            listener.onBeforeExecution(call);
        }
        catch (Exception e) {
            logger.warn("invokeOnBeforeExecution failed on '{}'\n{}", listener.getClass(), (Object)e);
        }
    }

    protected <T> void invokeOnAfterExecution(OnRetrofitCallExecutionListener listener, Call<T> call, Response<T> response) {
        try {
            listener.onExecutionSuccessful(call, response);
        }
        catch (Exception e) {
            logger.warn("invokeOnAfterExecution failed on '{}'\n{}", listener.getClass(), (Object)e);
        }
    }

    protected <T> void invokeOnExecutionSuccessful(OnRetrofitCallExecutionListener listener, Call<T> call, Response<T> response) {
        try {
            listener.onExecutionSuccessful(call, response);
        }
        catch (Exception e) {
            logger.warn("invokeOnExecutionSuccessful failed on '{}'\n{}", listener.getClass(), (Object)e);
        }
    }
}

