/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.util;

import java.io.IOException;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import pl.grizzlysoftware.dotykacka.client.v2.model.AccessToken;
import pl.grizzlysoftware.dotykacka.util.AccessTokenProvider;

public class TokenRenewingRequestInterceptor
implements Interceptor {
    private final AccessTokenProvider accessTokenProvider;

    public TokenRenewingRequestInterceptor(AccessTokenProvider accessTokenProvider) {
        this.accessTokenProvider = Objects.requireNonNull(accessTokenProvider);
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        AccessToken accessToken = this.accessTokenProvider.acquireToken();
        Request request = chain.request().newBuilder().header("Authorization", "Bearer " + accessToken.token).build();
        return chain.proceed(request);
    }
}

