/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.util;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import pl.grizzlysoftware.util.JacksonProvider;

public class ETagRequestHeaderApplier
implements Interceptor {
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Request oldRequest = chain.request();
        RequestBody body = oldRequest.body();
        if (Objects.isNull(body)) {
            return chain.proceed(oldRequest);
        }
        Buffer sink = new Buffer();
        body.writeTo((BufferedSink)sink);
        JsonNode deserializedBody = JacksonProvider.mapper.readTree(sink.inputStream());
        JsonNode entity = deserializedBody.isArray() && !deserializedBody.isEmpty() ? deserializedBody.get(0) : deserializedBody;
        JsonNode tagNode = entity.get("etag");
        Request.Builder requestBuilder = oldRequest.newBuilder();
        if (tagNode != null) {
            String etag = tagNode.asText();
            requestBuilder.header("If-Match", etag);
        }
        return chain.proceed(requestBuilder.build());
    }
}

