/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.util;

import java.util.Collection;
import pl.grizzlysoftware.dotykacka.client.v2.model.CloudEntity;
import pl.grizzlysoftware.dotykacka.client.v2.model.ResultPage;
import pl.grizzlysoftware.util.OnRetrofitCallExecutionListener;
import retrofit2.Call;
import retrofit2.Response;

public class ETagCloudEntityApplier
implements OnRetrofitCallExecutionListener {
    @Override
    public <T> void onBeforeExecution(Call<T> call) {
    }

    @Override
    public <T> void onAfterExecution(Call<T> call, Response<T> response) {
    }

    @Override
    public <T> void onExecutionSuccessful(Call<T> call, Response<T> response) {
        String etag = response.headers().get("ETag");
        Object body = response.body();
        this.applyEtag(body, etag);
    }

    public <T> void applyEtag(T body, String etag) {
        etag = this.adjustEtag(etag);
        if (body instanceof Collection) {
            this.applyOnEntities(body, etag);
        } else if (body instanceof CloudEntity) {
            this.applyOnEntity(body, etag);
        } else if (body instanceof ResultPage) {
            this.applyOnEntities(((ResultPage)body).data, etag);
        }
    }

    protected String adjustEtag(String etag) {
        if (etag == null) {
            return null;
        }
        return etag.replaceAll("\"", "");
    }

    protected void applyOnEntity(Object entity, String etag) {
        CloudEntity cloudEntity = (CloudEntity)entity;
        cloudEntity.etag = etag;
    }

    protected void applyOnEntities(Object entities, String etag) {
        Collection cloudEntities = (Collection)entities;
        cloudEntities.stream().filter(CloudEntity.class::isInstance).forEach(e -> this.applyOnEntity(e, etag));
    }
}

