/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.client.v2.service;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collection;
import pl.grizzlysoftware.dotykacka.client.v2.model.ProductStock;
import pl.grizzlysoftware.dotykacka.client.v2.model.ResultPage;
import pl.grizzlysoftware.dotykacka.client.v2.model.Warehouse;
import pl.grizzlysoftware.dotykacka.client.v2.model.WarehouseItemSale;
import pl.grizzlysoftware.dotykacka.client.v2.model.WarehouseStockUp;
import pl.grizzlysoftware.dotykacka.client.v2.model.WarehouseTransfer;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface WarehouseService {
    @POST(value=" ")
    public Call<Collection<Warehouse>> createWarehouses(@Body Collection<Warehouse> var1);

    @PUT(value=" ")
    public Call<Collection<Warehouse>> updateWarehouses(@Body Collection<Warehouse> var1);

    @PUT(value="{warehouseId}")
    public Call<Warehouse> updateWarehouse(@Path(value="warehouseId") Long var1, @Body Warehouse var2);

    @PATCH(value="{warehouseId}")
    public Call<Warehouse> patchWarehouse(@Path(value="warehouseId") Long var1, @Body Warehouse var2);

    @DELETE(value="{warehouseId}")
    public Call<Warehouse> deleteWarehouse(@Path(value="warehouseId") Long var1);

    @GET(value="{warehouseId}")
    public Call<Warehouse> getWarehouse(@Path(value="warehouseId") Long var1);

    @GET(value=" ")
    public Call<ResultPage<Warehouse>> getWarehouses(@Query(value="page") int var1, @Query(value="limit") int var2, @Query(value="filter") String var3, @Query(value="sort") String var4);

    @GET(value="{warehouseId}/products")
    public Call<Collection<ProductStock>> getProductStocks(@Path(value="warehouseId") Long var1);

    @GET(value="{warehouseId}/products/{productId}")
    public Call<ProductStock> getProductStockById(@Path(value="warehouseId") Long var1, @Path(value="productId") Long var2);

    @POST(value="{warehouseId}/stockups")
    public Call<JsonNode> stockup(@Path(value="warehouseId") Long var1, @Body WarehouseStockUp var2);

    @POST(value="{warehouseId}/transfer")
    public Call<JsonNode> transfer(@Path(value="warehouseId") Long var1, @Body WarehouseTransfer var2);

    @POST(value="{warehouseId}/transfer")
    public Call<JsonNode> sales(@Path(value="warehouseId") Long var1, @Body WarehouseItemSale var2);
}

