/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.client.v2.model;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import pl.grizzlysoftware.dotykacka.util.exception.ExceptionPreconditions;

public class AccessToken {
    public final String token;
    @JsonIgnore
    private final DecodedJWT decodedToken;

    @JsonCreator
    public AccessToken(@JsonProperty(value="accessToken") String token) {
        ExceptionPreconditions.checkNotNull(token, "20211106:071524", "accessToken cannot be null");
        ExceptionPreconditions.checkArgument(token.isBlank(), "20211106:071600", "accessToken cannot be blank");
        this.token = token;
        this.decodedToken = JWT.decode((String)token);
    }

    public String subject() {
        return this.decodedToken.getSubject();
    }

    public String issuer() {
        return this.decodedToken.getIssuer();
    }

    public Date issuedAt() {
        return this.decodedToken.getIssuedAt();
    }

    public Date expiresAt() {
        return this.decodedToken.getExpiresAt();
    }

    public boolean isExpired() {
        return this.expiresAt().toInstant().isBefore(new Date().toInstant());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessToken that = (AccessToken)o;
        return new EqualsBuilder().append((Object)this.token, (Object)that.token).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.token).toHashCode();
    }
}

