/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.client.v2.facade;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collection;
import java.util.Collections;
import pl.grizzlysoftware.dotykacka.client.v2.facade.DotykackaApiService;
import pl.grizzlysoftware.dotykacka.client.v2.model.ProductStock;
import pl.grizzlysoftware.dotykacka.client.v2.model.ResultPage;
import pl.grizzlysoftware.dotykacka.client.v2.model.Warehouse;
import pl.grizzlysoftware.dotykacka.client.v2.model.WarehouseItemSale;
import pl.grizzlysoftware.dotykacka.client.v2.model.WarehouseStockUp;
import pl.grizzlysoftware.dotykacka.client.v2.model.WarehouseTransfer;
import pl.grizzlysoftware.dotykacka.client.v2.service.WarehouseService;

public class WarehouseServiceFacade
extends DotykackaApiService<WarehouseService> {
    public WarehouseServiceFacade(WarehouseService service) {
        super(service);
    }

    public Warehouse createWarehouse(Warehouse warehouse) {
        return this.createWarehouses(Collections.singletonList(warehouse)).stream().findAny().orElseThrow();
    }

    public Collection<Warehouse> createWarehouses(Collection<Warehouse> warehouses) {
        return this.execute(((WarehouseService)this.service).createWarehouses(warehouses));
    }

    public Collection<Warehouse> updateWarehouses(Collection<Warehouse> warehouses) {
        return this.execute(((WarehouseService)this.service).updateWarehouses(warehouses));
    }

    public Warehouse updateWarehouse(Warehouse warehouse) {
        return this.execute(((WarehouseService)this.service).updateWarehouse(warehouse.id, warehouse));
    }

    public Warehouse patchWarehouse(Warehouse warehouse) {
        return this.execute(((WarehouseService)this.service).patchWarehouse(warehouse.id, warehouse));
    }

    public Warehouse deleteWarehouse(Long warehouseId) {
        return this.execute(((WarehouseService)this.service).deleteWarehouse(warehouseId));
    }

    public Warehouse getWarehouse(Long id) {
        return this.execute(((WarehouseService)this.service).getWarehouse(id));
    }

    public ResultPage<Warehouse> getWarehouses(int page, int pageSize, String filter, String sort) {
        return this.execute(((WarehouseService)this.service).getWarehouses(page, pageSize, filter, sort));
    }

    public ResultPage<Warehouse> getWarehouses(int page, int pageSize, String sort) {
        return this.getWarehouses(page, pageSize, null, sort);
    }

    public Collection<Warehouse> getAllWarehouses(String sort) {
        return this.batchLoader.load(page -> this.getWarehouses(page.page, page.pageSize, sort));
    }

    public Collection<Warehouse> getAllWarehouses() {
        return this.getAllWarehouses(null);
    }

    public Collection<ProductStock> getProductStocks(Long warehouseId) {
        return this.execute(((WarehouseService)this.service).getProductStocks(warehouseId));
    }

    public ProductStock getProductStockById(Long warehouseId, Long productId) {
        return this.execute(((WarehouseService)this.service).getProductStockById(warehouseId, productId));
    }

    public JsonNode stockup(WarehouseStockUp body) {
        return this.execute(((WarehouseService)this.service).stockup(body.warehouseId, body));
    }

    public JsonNode transfer(WarehouseTransfer body) {
        return this.execute(((WarehouseService)this.service).transfer(body.warehouseId, body));
    }

    public JsonNode sales(WarehouseItemSale body) {
        return this.execute(((WarehouseService)this.service).sales(body.warehouseId, body));
    }
}

