/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.client.v2.facade;

import java.util.Collection;
import java.util.Collections;
import pl.grizzlysoftware.dotykacka.client.v2.facade.DotykackaApiService;
import pl.grizzlysoftware.dotykacka.client.v2.model.ResultPage;
import pl.grizzlysoftware.dotykacka.client.v2.model.Supplier;
import pl.grizzlysoftware.dotykacka.client.v2.service.SupplierService;

public class SupplierServiceFacade
extends DotykackaApiService<SupplierService> {
    public SupplierServiceFacade(SupplierService service) {
        super(service);
    }

    public Supplier createSupplier(Supplier supplier) {
        return this.createSuppliers(Collections.singletonList(supplier)).stream().findAny().orElseThrow();
    }

    public Collection<Supplier> createSuppliers(Collection<Supplier> suppliers) {
        return this.execute(((SupplierService)this.service).createSuppliers(suppliers));
    }

    public Collection<Supplier> updateSuppliers(Collection<Supplier> suppliers) {
        return this.execute(((SupplierService)this.service).updateSuppliers(suppliers));
    }

    public Supplier updateSupplier(Supplier supplier) {
        return this.execute(((SupplierService)this.service).updateSupplier(supplier.id, supplier));
    }

    public Supplier patchSupplier(Supplier supplier) {
        return this.execute(((SupplierService)this.service).patchSupplier(supplier.id, supplier));
    }

    public Supplier deleteSupplier(Long supplierId) {
        return this.execute(((SupplierService)this.service).deleteSupplier(supplierId));
    }

    public Supplier getSupplier(Long id) {
        return this.execute(((SupplierService)this.service).getSupplier(id));
    }

    public ResultPage<Supplier> getSuppliers(int page, int pageSize, String filter, String sort) {
        return this.execute(((SupplierService)this.service).getSuppliers(page, pageSize, filter, sort));
    }

    public ResultPage<Supplier> getSuppliers(int page, int pageSize, String sort) {
        return this.getSuppliers(page, pageSize, null, sort);
    }

    public Collection<Supplier> getAllSuppliers(String sort) {
        return this.batchLoader.load(page -> this.getSuppliers(page.page, page.pageSize, sort));
    }

    public Collection<Supplier> getAllSuppliers() {
        return this.getAllSuppliers(null);
    }
}

