/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.client.v2.facade;

import java.util.Collection;
import java.util.Collections;
import pl.grizzlysoftware.dotykacka.client.v2.facade.DotykackaApiService;
import pl.grizzlysoftware.dotykacka.client.v2.model.Reservation;
import pl.grizzlysoftware.dotykacka.client.v2.model.ResultPage;
import pl.grizzlysoftware.dotykacka.client.v2.service.ReservationService;

public class ReservationServiceFacade
extends DotykackaApiService<ReservationService> {
    public ReservationServiceFacade(ReservationService service) {
        super(service);
    }

    public Reservation createReservation(Reservation reservation) {
        return this.createReservations(Collections.singletonList(reservation)).stream().findAny().orElseThrow();
    }

    public Collection<Reservation> createReservations(Collection<Reservation> reservations) {
        return this.execute(((ReservationService)this.service).createReservations(reservations));
    }

    public Collection<Reservation> updateReservations(Collection<Reservation> reservations) {
        return this.execute(((ReservationService)this.service).updateReservations(reservations));
    }

    public Reservation updateReservation(Reservation reservation) {
        return this.execute(((ReservationService)this.service).updateReservation(reservation.id, reservation));
    }

    public Reservation patchReservation(Reservation reservation) {
        return this.execute(((ReservationService)this.service).patchReservation(reservation.id, reservation));
    }

    public Reservation deleteReservation(Long reservationId) {
        return this.execute(((ReservationService)this.service).deleteReservation(reservationId));
    }

    public Reservation getReservation(Long id) {
        return this.execute(((ReservationService)this.service).getReservation(id));
    }

    public ResultPage<Reservation> getReservations(int page, int pageSize, String filter, String sort) {
        return this.execute(((ReservationService)this.service).getReservations(page, pageSize, filter, sort));
    }

    public ResultPage<Reservation> getReservations(int page, int pageSize, String sort) {
        return this.getReservations(page, pageSize, null, sort);
    }

    public Collection<Reservation> getAllReservations(String sort) {
        return this.batchLoader.load(page -> this.getReservations(page.page, page.pageSize, sort));
    }

    public Collection<Reservation> getAllReservations() {
        return this.getAllReservations(null);
    }
}

