/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.client.v2.facade;

import java.util.Collection;
import java.util.Collections;
import pl.grizzlysoftware.dotykacka.client.v2.facade.DotykackaApiService;
import pl.grizzlysoftware.dotykacka.client.v2.model.Product;
import pl.grizzlysoftware.dotykacka.client.v2.model.ResultPage;
import pl.grizzlysoftware.dotykacka.client.v2.service.ProductService;

public class ProductServiceFacade
extends DotykackaApiService<ProductService> {
    public ProductServiceFacade(ProductService service) {
        super(service);
    }

    public Product createProduct(Product product) {
        return this.createProducts(Collections.singletonList(product)).stream().findAny().orElseThrow();
    }

    public Collection<Product> createProducts(Collection<Product> products) {
        return this.execute(((ProductService)this.service).createProducts(products));
    }

    public Collection<Product> updateProducts(Collection<Product> products) {
        return this.execute(((ProductService)this.service).updateProducts(products));
    }

    public Product updateProduct(Product product) {
        return this.execute(((ProductService)this.service).updateProduct(product.id, product));
    }

    public Product patchProduct(Product product) {
        return this.execute(((ProductService)this.service).patchProduct(product.id, product));
    }

    public Product deleteProduct(Long productsId) {
        return this.execute(((ProductService)this.service).deleteProduct(productsId));
    }

    public Product getProduct(Long id) {
        return this.execute(((ProductService)this.service).getProduct(id));
    }

    public ResultPage<Product> getProducts(int page, int pageSize, String include, String filter, String sort) {
        return this.execute(((ProductService)this.service).getProducts(page, pageSize, include, filter, sort));
    }

    public ResultPage<Product> getProducts(int page, int pageSize, String include, String sort) {
        return this.getProducts(page, pageSize, include, null, sort);
    }

    public Collection<Product> getAllProducts(String include, String filter, String sort) {
        return this.batchLoader.load(page -> this.getProducts(page.page, page.pageSize, include, filter, sort));
    }

    public Collection<Product> getAllProductsIncludingIngredients(String filter, String sort) {
        return this.getAllProducts("ingredients", filter, sort);
    }

    public Collection<Product> getAllProductsIncludingCustomizations(String filter, String sort) {
        return this.getAllProducts("customizations", filter, sort);
    }

    public Collection<Product> getAllProductsIncludingIngredientsAndCustomizations(String filter, String sort) {
        return this.getAllProducts("ingredients,customizations", filter, sort);
    }

    public Collection<Product> getAllProducts(String sort) {
        return this.getAllProducts(null, null, sort);
    }

    public Collection<Product> getAllProductsIncludingIngredients(String sort) {
        return this.getAllProductsIncludingIngredients(null, sort);
    }

    public Collection<Product> getAllProductsIncludingCustomizations(String sort) {
        return this.getAllProductsIncludingCustomizations(null, sort);
    }

    public Collection<Product> getAllProductsIncludingIngredientsAndCustomizations(String sort) {
        return this.getAllProductsIncludingIngredientsAndCustomizations(null, sort);
    }

    public Collection<Product> getAllProducts() {
        return this.getAllProducts(null);
    }
}

