/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.client.v2.facade;

import java.util.Collection;
import pl.grizzlysoftware.dotykacka.client.v2.facade.DotykackaApiService;
import pl.grizzlysoftware.dotykacka.client.v2.model.Order;
import pl.grizzlysoftware.dotykacka.client.v2.model.ResultPage;
import pl.grizzlysoftware.dotykacka.client.v2.service.OrderService;

public class OrderServiceFacade
extends DotykackaApiService<OrderService> {
    public OrderServiceFacade(OrderService service) {
        super(service);
    }

    public Order getOrder(Long id) {
        return this.execute(((OrderService)this.service).getOrder(id));
    }

    public ResultPage<Order> getOrders(int page, int pageSize, String include, String namedFilter, String filter, String sort) {
        return this.execute(((OrderService)this.service).getOrders(page, pageSize, include, namedFilter, filter, sort));
    }

    public ResultPage<Order> getOrders(int page, int pageSize, String include, String filter, String sort) {
        return this.getOrders(page, pageSize, include, null, filter, sort);
    }

    public ResultPage<Order> getOrders(int page, int pageSize, String include, String sort) {
        return this.getOrders(page, pageSize, include, null, null, sort);
    }

    public ResultPage<Order> getOrdersIncludingMoneyLogs(int page, int pageSize, String filter, String sort) {
        return this.getOrders(page, pageSize, "moneyLogs", null, filter, sort);
    }

    public ResultPage<Order> getOrdersIncludingOrderItems(int page, int pageSize, String filter, String sort) {
        return this.getOrders(page, pageSize, "orderItems", null, filter, sort);
    }

    public ResultPage<Order> getOrdersIncludingMoneyLogsAndOrderItems(int page, int pageSize, String filter, String sort) {
        return this.getOrders(page, pageSize, "moneyLogs,orderItems", null, filter, sort);
    }

    public Collection<Order> getAllOrders(String include, String filter, String sort) {
        return this.batchLoader.load(page -> this.getOrders(page.page, page.pageSize, include, null, filter, sort));
    }

    public Collection<Order> getAllOrdersIncludingOrderItems(String filter, String sort) {
        return this.batchLoader.load(page -> this.getOrdersIncludingOrderItems(page.page, page.pageSize, filter, sort));
    }

    public Collection<Order> getAllOrdersIncludingMoneyLogs(String filter, String sort) {
        return this.batchLoader.load(page -> this.getOrdersIncludingMoneyLogs(page.page, page.pageSize, filter, sort));
    }

    public Collection<Order> getAllOrdersIncludingOrderItemsAndMoneyLogs(String filter, String sort) {
        return this.batchLoader.load(page -> this.getOrdersIncludingMoneyLogsAndOrderItems(page.page, page.pageSize, filter, sort));
    }

    public Collection<Order> getAllOrders(String sort) {
        return this.getAllOrders(null, null, sort);
    }

    public Collection<Order> getAllOrdersIncludingOrderItems(String sort) {
        return this.getAllOrdersIncludingOrderItems(null, sort);
    }

    public Collection<Order> getAllOrdersIncludingMoneyLogs(String sort) {
        return this.getAllOrdersIncludingMoneyLogs(null, sort);
    }

    public Collection<Order> getAllOrdersIncludingOrderItemsAndMoneyLogs(String sort) {
        return this.getAllOrdersIncludingOrderItemsAndMoneyLogs(null, sort);
    }

    public Collection<Order> getAllOrders() {
        return this.getAllOrders(null);
    }
}

