/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.client.v2.facade;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import pl.grizzlysoftware.dotykacka.client.v2.facade.DotykackaApiService;
import pl.grizzlysoftware.dotykacka.client.v2.model.OrderItem;
import pl.grizzlysoftware.dotykacka.client.v2.model.ResultPage;
import pl.grizzlysoftware.dotykacka.client.v2.service.OrderItemService;

public class OrderItemServiceFacade
extends DotykackaApiService<OrderItemService> {
    private static final DateTimeFormatter RECEIPTS_RANGE_DATE_FORMATTER = DateTimeFormatter.ofPattern("YYYY-MM-dd'T'HH:mm:ss.SSSX").withZone(ZoneId.of("UTC"));
    private static final String RECEIPTS_RANGE_PATTERN = "completed|gteq|%s;completed|lt|%s";

    public OrderItemServiceFacade(OrderItemService service) {
        super(service);
    }

    public OrderItem getOrderItem(Long id) {
        return this.execute(((OrderItemService)this.service).getOrderItem(id));
    }

    public ResultPage<OrderItem> getOrderItems(int page, int pageSize, String filter, String sort) {
        return this.execute(((OrderItemService)this.service).getOrderItems(page, pageSize, filter, sort));
    }

    public ResultPage<OrderItem> getOrderItems(int page, int pageSize, String sort) {
        return this.getOrderItems(page, pageSize, null, sort);
    }

    public ResultPage<OrderItem> getOrderItemsForTimeRange(ZonedDateTime startDate, ZonedDateTime endDate, int page, int pageSize, String sort) {
        String dateRange = String.format(RECEIPTS_RANGE_PATTERN, this.formatted(startDate), this.formatted(endDate));
        return this.execute(((OrderItemService)this.service).getOrderItems(page, pageSize, dateRange, sort));
    }

    public Collection<OrderItem> getAllOrderItemsForTimeRange(ZonedDateTime startDate, ZonedDateTime endDate, String sort) {
        return this.batchLoader.load(page -> this.getOrderItemsForTimeRange(startDate, endDate, page.page, page.pageSize, sort));
    }

    public Collection<OrderItem> getAllOrderItems(String sort) {
        return this.batchLoader.load(page -> this.getOrderItems(page.page, page.pageSize, sort));
    }

    public Collection<OrderItem> getAllOrderItems() {
        return this.getAllOrderItems(null);
    }

    private String formatted(ZonedDateTime zonedDateTime) {
        return RECEIPTS_RANGE_DATE_FORMATTER.format(zonedDateTime);
    }
}

