/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.client.v2.facade;

import java.util.Collection;
import java.util.Collections;
import pl.grizzlysoftware.dotykacka.client.v2.facade.DotykackaApiService;
import pl.grizzlysoftware.dotykacka.client.v2.model.Employee;
import pl.grizzlysoftware.dotykacka.client.v2.model.ResultPage;
import pl.grizzlysoftware.dotykacka.client.v2.service.EmployeeService;

public class EmployeeServiceFacade
extends DotykackaApiService<EmployeeService> {
    public EmployeeServiceFacade(EmployeeService service) {
        super(service);
    }

    public Employee createEmployee(Employee employee) {
        return this.createEmployees(Collections.singletonList(employee)).stream().findAny().orElseThrow();
    }

    public Collection<Employee> createEmployees(Collection<Employee> employees) {
        return this.execute(((EmployeeService)this.service).createEmployees(employees));
    }

    public Collection<Employee> updateEmployees(Collection<Employee> employees) {
        return this.execute(((EmployeeService)this.service).updateEmployees(employees));
    }

    public Employee updateEmployee(Employee employee) {
        return this.execute(((EmployeeService)this.service).updateEmployee(employee.id, employee));
    }

    public Employee patchEmployee(Employee employee) {
        return this.execute(((EmployeeService)this.service).patchEmployee(employee.id, employee));
    }

    public Employee deleteEmployee(Long employeeId) {
        return this.execute(((EmployeeService)this.service).deleteEmployee(employeeId));
    }

    public Employee getEmployee(Long id) {
        return this.execute(((EmployeeService)this.service).getEmployee(id));
    }

    public ResultPage<Employee> getEmployees(int page, int pageSize, String filter, String sort) {
        return this.execute(((EmployeeService)this.service).getEmployees(page, pageSize, filter, sort));
    }

    public ResultPage<Employee> getEmployees(int page, int pageSize, String sort) {
        return this.getEmployees(page, pageSize, null, sort);
    }

    public Collection<Employee> getAllEmployees(String sort) {
        return this.batchLoader.load(page -> this.getEmployees(page.page, page.pageSize, sort));
    }

    public Collection<Employee> getAllEmployees() {
        return this.getAllEmployees(null);
    }
}

