/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.client.v2.facade;

import java.util.Collection;
import java.util.Collections;
import pl.grizzlysoftware.dotykacka.client.v2.facade.DotykackaApiService;
import pl.grizzlysoftware.dotykacka.client.v2.model.Customer;
import pl.grizzlysoftware.dotykacka.client.v2.model.ResultPage;
import pl.grizzlysoftware.dotykacka.client.v2.service.CustomerService;

public class CustomerServiceFacade
extends DotykackaApiService<CustomerService> {
    public CustomerServiceFacade(CustomerService service) {
        super(service);
    }

    public Customer createCustomer(Customer customer) {
        return this.createCustomers(Collections.singletonList(customer)).stream().findAny().orElseThrow();
    }

    public Collection<Customer> createCustomers(Collection<Customer> customers) {
        return this.execute(((CustomerService)this.service).createCustomers(customers));
    }

    public Collection<Customer> updateCustomers(Collection<Customer> customers) {
        return this.execute(((CustomerService)this.service).updateCustomers(customers));
    }

    public Customer updateCustomer(Customer customer) {
        return this.execute(((CustomerService)this.service).updateCustomer(customer.id, customer));
    }

    public Customer patchCustomer(Customer customer) {
        return this.execute(((CustomerService)this.service).patchCustomer(customer.id, customer));
    }

    public Customer deleteCustomer(Long customerId) {
        return this.execute(((CustomerService)this.service).deleteCustomer(customerId));
    }

    public Customer getCustomer(Long id) {
        return this.execute(((CustomerService)this.service).getCustomer(id));
    }

    public ResultPage<Customer> getCustomers(int page, int pageSize, String filter, String sort) {
        return this.execute(((CustomerService)this.service).getCustomers(page, pageSize, filter, sort));
    }

    public ResultPage<Customer> getCustomers(int page, int pageSize, String sort) {
        return this.getCustomers(page, pageSize, null, sort);
    }

    public Collection<Customer> getAllCustomers(String sort) {
        return this.batchLoader.load(page -> this.getCustomers(page.page, page.pageSize, sort));
    }

    public Collection<Customer> getAllCustomers() {
        return this.getAllCustomers(null);
    }
}

