/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.client.v2.facade;

import java.util.Collection;
import java.util.Collections;
import pl.grizzlysoftware.dotykacka.client.v2.facade.DotykackaApiService;
import pl.grizzlysoftware.dotykacka.client.v2.model.Category;
import pl.grizzlysoftware.dotykacka.client.v2.model.ResultPage;
import pl.grizzlysoftware.dotykacka.client.v2.service.CategoryService;

public class CategoryServiceFacade
extends DotykackaApiService<CategoryService> {
    public CategoryServiceFacade(CategoryService service) {
        super(service);
    }

    public Category createCategory(Category category) {
        return this.createCategories(Collections.singletonList(category)).stream().findAny().orElseThrow();
    }

    public Collection<Category> createCategories(Collection<Category> categories) {
        return this.execute(((CategoryService)this.service).createCategories(categories));
    }

    public Collection<Category> updateCategories(Collection<Category> categories) {
        return this.execute(((CategoryService)this.service).updateCategories(categories));
    }

    public Category updateCategory(Category category) {
        return this.execute(((CategoryService)this.service).updateCategory(category.id, category));
    }

    public Category patchCategory(Category category) {
        return this.execute(((CategoryService)this.service).patchCategory(category.id, category));
    }

    public Category deleteCategory(Long categoryId) {
        return this.execute(((CategoryService)this.service).deleteCategory(categoryId));
    }

    public Category getCategory(Long id) {
        return this.execute(((CategoryService)this.service).getCategory(id));
    }

    public ResultPage<Category> getCategories(int page, int pageSize, String filter, String sort) {
        return this.execute(((CategoryService)this.service).getCategories(page, pageSize, filter, sort));
    }

    public ResultPage<Category> getCategories(int page, int pageSize, String sort) {
        return this.getCategories(page, pageSize, null, sort);
    }

    public Collection<Category> getAllCategories(String sort) {
        return this.batchLoader.load(page -> this.getCategories(page.page, page.pageSize, sort));
    }

    public Collection<Category> getAllCategories() {
        return this.getAllCategories(null);
    }
}

