/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.client.v2;

import java.util.List;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import pl.grizzlysoftware.dotykacka.client.v2.ApiConfiguration;
import pl.grizzlysoftware.dotykacka.client.v2.facade.AuthenticationServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v2.facade.BranchServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v2.facade.CategoryServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v2.facade.CloudServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v2.facade.CustomerServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v2.facade.DeliveryNoteServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v2.facade.DiscountGroupServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v2.facade.EetSubjectServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v2.facade.EmployeeServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v2.facade.MoneyLogServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v2.facade.OrderItemServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v2.facade.OrderServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v2.facade.ProductCustomizationServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v2.facade.ProductIngredientServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v2.facade.ProductServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v2.facade.ReservationServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v2.facade.SupplierServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v2.facade.TableServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v2.facade.TagServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v2.facade.WarehouseBranchServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v2.facade.WarehouseServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v2.service.AuthenticationService;
import pl.grizzlysoftware.dotykacka.client.v2.service.BranchService;
import pl.grizzlysoftware.dotykacka.client.v2.service.CategoryService;
import pl.grizzlysoftware.dotykacka.client.v2.service.CloudService;
import pl.grizzlysoftware.dotykacka.client.v2.service.CustomerService;
import pl.grizzlysoftware.dotykacka.client.v2.service.DeliveryNoteService;
import pl.grizzlysoftware.dotykacka.client.v2.service.DiscountGroupService;
import pl.grizzlysoftware.dotykacka.client.v2.service.EetSubjectService;
import pl.grizzlysoftware.dotykacka.client.v2.service.EmployeeService;
import pl.grizzlysoftware.dotykacka.client.v2.service.MoneyLogService;
import pl.grizzlysoftware.dotykacka.client.v2.service.OrderItemService;
import pl.grizzlysoftware.dotykacka.client.v2.service.OrderService;
import pl.grizzlysoftware.dotykacka.client.v2.service.ProductCustomizationService;
import pl.grizzlysoftware.dotykacka.client.v2.service.ProductIngredientService;
import pl.grizzlysoftware.dotykacka.client.v2.service.ProductService;
import pl.grizzlysoftware.dotykacka.client.v2.service.ReservationService;
import pl.grizzlysoftware.dotykacka.client.v2.service.SupplierService;
import pl.grizzlysoftware.dotykacka.client.v2.service.TableService;
import pl.grizzlysoftware.dotykacka.client.v2.service.TagService;
import pl.grizzlysoftware.dotykacka.client.v2.service.WarehouseBranchService;
import pl.grizzlysoftware.dotykacka.client.v2.service.WarehouseService;
import pl.grizzlysoftware.dotykacka.util.AccessTokenProvider;
import pl.grizzlysoftware.dotykacka.util.ETagCloudEntityApplier;
import pl.grizzlysoftware.dotykacka.util.ETagRequestHeaderApplier;
import pl.grizzlysoftware.dotykacka.util.TokenRenewingRequestInterceptor;
import pl.grizzlysoftware.dotykacka.util.exception.ExceptionPreconditions;
import pl.grizzlysoftware.util.CompositeOnRetroCallExecutionListener;
import pl.grizzlysoftware.util.OkHttpClientUtils;
import pl.grizzlysoftware.util.OkHttpLoggingInterceptor;
import pl.grizzlysoftware.util.RetrofitUtils;

public class DotykackaApiClient {
    public final AuthenticationService authenticationService;
    public final AuthenticationServiceFacade authenticationServiceFacade;
    public final CloudServiceFacade cloudServiceFacade;
    public final BranchServiceFacade branchServiceFacade;
    public final CategoryServiceFacade categoryServiceFacade;
    public final CustomerServiceFacade customerServiceFacade;
    public final DiscountGroupServiceFacade discountGroupServiceFacade;
    public final DeliveryNoteServiceFacade deliveryNoteServiceFacade;
    public final EmployeeServiceFacade employeeServiceFacade;
    public final MoneyLogServiceFacade moneyLogServiceFacade;
    public final OrderServiceFacade orderServiceFacade;
    public final OrderItemServiceFacade orderItemServiceFacade;
    public final ProductServiceFacade productServiceFacade;
    public final ProductCustomizationServiceFacade productCustomizationServiceFacade;
    public final ProductIngredientServiceFacade productIngredientServiceFacade;
    public final ReservationServiceFacade reservationServiceFacade;
    public final SupplierServiceFacade supplierServiceFacade;
    public final TableServiceFacade tableServiceFacade;
    public final TagServiceFacade tagServiceFacade;
    public final WarehouseServiceFacade warehouseServiceFacade;
    public final WarehouseBranchServiceFacade warehouseBranchServiceFacade;
    public final EetSubjectServiceFacade eetSubjectServiceFacade;

    public DotykackaApiClient(ApiConfiguration configuration) {
        ExceptionPreconditions.checkNotNull(configuration, "20211106:084700", "ApiConfiguration cannot be null");
        OkHttpClient httpClient = OkHttpClientUtils.builder().callTimeout(configuration.requestTimeout).addInterceptor((Interceptor)new OkHttpLoggingInterceptor()).build();
        this.authenticationService = RetrofitUtils.service(httpClient, configuration.url, AuthenticationService.class);
        this.authenticationServiceFacade = new AuthenticationServiceFacade(this.authenticationService, configuration.cloudId, configuration.refreshToken);
        OkHttpClient reqHttpClient = OkHttpClientUtils.builder().callTimeout(configuration.requestTimeout).addInterceptor((Interceptor)new TokenRenewingRequestInterceptor(new AccessTokenProvider(this.authenticationServiceFacade))).addInterceptor((Interceptor)new ETagRequestHeaderApplier()).addInterceptor((Interceptor)new OkHttpLoggingInterceptor()).build();
        CompositeOnRetroCallExecutionListener compositeExecutionListener = new CompositeOnRetroCallExecutionListener(List.of(new ETagCloudEntityApplier()));
        String cloudServiceUrl = this.cloudServiceUrl(configuration.url);
        CloudService cloudService = RetrofitUtils.service(reqHttpClient, cloudServiceUrl, CloudService.class);
        this.cloudServiceFacade = new CloudServiceFacade(cloudService);
        String apiUrl = cloudServiceUrl + "/" + configuration.cloudId;
        BranchService branchService = RetrofitUtils.service(reqHttpClient, this.branchServiceUrl(apiUrl), BranchService.class);
        this.branchServiceFacade = new BranchServiceFacade(branchService);
        this.branchServiceFacade.setCallExecutionListener(compositeExecutionListener);
        CategoryService categoryService = RetrofitUtils.service(reqHttpClient, this.categoryServiceUrl(apiUrl), CategoryService.class);
        this.categoryServiceFacade = new CategoryServiceFacade(categoryService);
        this.categoryServiceFacade.setCallExecutionListener(compositeExecutionListener);
        CustomerService customerService = RetrofitUtils.service(reqHttpClient, this.customerServiceUrl(apiUrl), CustomerService.class);
        this.customerServiceFacade = new CustomerServiceFacade(customerService);
        this.customerServiceFacade.setCallExecutionListener(compositeExecutionListener);
        DeliveryNoteService deliveryNoteService = RetrofitUtils.service(reqHttpClient, apiUrl, DeliveryNoteService.class);
        this.deliveryNoteServiceFacade = new DeliveryNoteServiceFacade(deliveryNoteService);
        this.deliveryNoteServiceFacade.setCallExecutionListener(compositeExecutionListener);
        DiscountGroupService discountGroupService = RetrofitUtils.service(reqHttpClient, this.discountGroupServiceUrl(apiUrl), DiscountGroupService.class);
        this.discountGroupServiceFacade = new DiscountGroupServiceFacade(discountGroupService);
        this.discountGroupServiceFacade.setCallExecutionListener(compositeExecutionListener);
        EetSubjectService eetSubjectService = RetrofitUtils.service(reqHttpClient, this.eetSubjectServiceUrl(apiUrl), EetSubjectService.class);
        this.eetSubjectServiceFacade = new EetSubjectServiceFacade(eetSubjectService);
        this.eetSubjectServiceFacade.setCallExecutionListener(compositeExecutionListener);
        EmployeeService employeeService = RetrofitUtils.service(reqHttpClient, this.employeeServiceUrl(apiUrl), EmployeeService.class);
        this.employeeServiceFacade = new EmployeeServiceFacade(employeeService);
        this.employeeServiceFacade.setCallExecutionListener(compositeExecutionListener);
        MoneyLogService moneyLogService = RetrofitUtils.service(reqHttpClient, this.moneyLogServiceUrl(apiUrl), MoneyLogService.class);
        this.moneyLogServiceFacade = new MoneyLogServiceFacade(moneyLogService);
        this.moneyLogServiceFacade.setCallExecutionListener(compositeExecutionListener);
        OrderService orderService = RetrofitUtils.service(reqHttpClient, this.orderServiceUrl(apiUrl), OrderService.class);
        this.orderServiceFacade = new OrderServiceFacade(orderService);
        this.orderServiceFacade.setCallExecutionListener(compositeExecutionListener);
        OrderItemService orderItemService = RetrofitUtils.service(reqHttpClient, this.orderItemServiceUrl(apiUrl), OrderItemService.class);
        this.orderItemServiceFacade = new OrderItemServiceFacade(orderItemService);
        this.orderItemServiceFacade.setCallExecutionListener(compositeExecutionListener);
        ProductService productService = RetrofitUtils.service(reqHttpClient, this.productServiceUrl(apiUrl), ProductService.class);
        this.productServiceFacade = new ProductServiceFacade(productService);
        this.productServiceFacade.setCallExecutionListener(compositeExecutionListener);
        ProductCustomizationService productCustomizationService = RetrofitUtils.service(reqHttpClient, this.productCustomizationServiceUrl(apiUrl), ProductCustomizationService.class);
        this.productCustomizationServiceFacade = new ProductCustomizationServiceFacade(productCustomizationService);
        this.productCustomizationServiceFacade.setCallExecutionListener(compositeExecutionListener);
        ProductIngredientService productIngredientService = RetrofitUtils.service(reqHttpClient, this.productIngredientServiceUrl(apiUrl), ProductIngredientService.class);
        this.productIngredientServiceFacade = new ProductIngredientServiceFacade(productIngredientService);
        this.productIngredientServiceFacade.setCallExecutionListener(compositeExecutionListener);
        ReservationService reservationService = RetrofitUtils.service(reqHttpClient, this.reservationServiceUrl(apiUrl), ReservationService.class);
        this.reservationServiceFacade = new ReservationServiceFacade(reservationService);
        this.reservationServiceFacade.setCallExecutionListener(compositeExecutionListener);
        SupplierService supplierService = RetrofitUtils.service(reqHttpClient, this.supplierServiceUrl(apiUrl), SupplierService.class);
        this.supplierServiceFacade = new SupplierServiceFacade(supplierService);
        this.supplierServiceFacade.setCallExecutionListener(compositeExecutionListener);
        TableService tableService = RetrofitUtils.service(reqHttpClient, this.tableServiceUrl(apiUrl), TableService.class);
        this.tableServiceFacade = new TableServiceFacade(tableService);
        this.tableServiceFacade.setCallExecutionListener(compositeExecutionListener);
        TagService tagService = RetrofitUtils.service(reqHttpClient, this.tagServiceUrl(apiUrl), TagService.class);
        this.tagServiceFacade = new TagServiceFacade(tagService);
        this.tagServiceFacade.setCallExecutionListener(compositeExecutionListener);
        WarehouseService warehouseService = RetrofitUtils.service(reqHttpClient, this.warehouseServiceUrl(apiUrl), WarehouseService.class);
        this.warehouseServiceFacade = new WarehouseServiceFacade(warehouseService);
        this.warehouseServiceFacade.setCallExecutionListener(compositeExecutionListener);
        WarehouseBranchService warehouseBranchService = RetrofitUtils.service(reqHttpClient, this.warehouseBranchServiceUrl(apiUrl), WarehouseBranchService.class);
        this.warehouseBranchServiceFacade = new WarehouseBranchServiceFacade(warehouseBranchService);
        this.warehouseBranchServiceFacade.setCallExecutionListener(compositeExecutionListener);
    }

    private String discountGroupServiceUrl(String url) {
        return url + "/discount-groups";
    }

    private String eetSubjectServiceUrl(String url) {
        return url + "/eet-subjects";
    }

    private String warehouseBranchServiceUrl(String url) {
        return url + "/warehouse-branches";
    }

    private String warehouseServiceUrl(String url) {
        return url + "/warehouses";
    }

    private String tagServiceUrl(String url) {
        return url + "/tags";
    }

    private String tableServiceUrl(String url) {
        return url + "/tables";
    }

    private String supplierServiceUrl(String url) {
        return url + "/suppliers";
    }

    private String reservationServiceUrl(String url) {
        return url + "/reservations";
    }

    private String productIngredientServiceUrl(String url) {
        return url + "/product-ingredients";
    }

    private String productCustomizationServiceUrl(String url) {
        return url + "/product-customizations";
    }

    private String productServiceUrl(String url) {
        return url + "/products";
    }

    private String orderItemServiceUrl(String url) {
        return url + "/order-items";
    }

    private String orderServiceUrl(String url) {
        return url + "/orders";
    }

    private String moneyLogServiceUrl(String url) {
        return url + "/money-logs";
    }

    private String employeeServiceUrl(String url) {
        return url + "/employees";
    }

    private String categoryServiceUrl(String url) {
        return url + "/categories";
    }

    private String customerServiceUrl(String url) {
        return url + "/customers";
    }

    private String branchServiceUrl(String url) {
        return url + "/branches";
    }

    private String cloudServiceUrl(String url) {
        return url + "/clouds";
    }
}

