/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.client.v2;

import java.time.Duration;
import pl.grizzlysoftware.dotykacka.util.exception.ExceptionPreconditions;

public class ApiConfiguration {
    public final String url;
    public final Long cloudId;
    public final String refreshToken;
    public final Duration requestTimeout;

    public ApiConfiguration(String url, String refreshToken, Long cloudId, Duration requestTimeout) {
        ExceptionPreconditions.checkNotNull(url, "20211106:065450", "url cannot be null");
        ExceptionPreconditions.checkArgument(url.isBlank(), "20211106:065450", "url cannot be blank");
        ExceptionPreconditions.checkNotNull(cloudId, "20211106:064700", "cloudId cannot be null");
        ExceptionPreconditions.checkNotNull(refreshToken, "20211106:064740", "refreshToken cannot be null");
        ExceptionPreconditions.checkArgument(refreshToken.isBlank(), "20211106:064741", "refreshToken cannot be blank");
        this.url = url;
        this.cloudId = cloudId;
        this.refreshToken = refreshToken;
        this.requestTimeout = requestTimeout != null ? requestTimeout : Duration.ofSeconds(60L);
    }
}

